/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import org.springframework.security.acls.domain.BasePermission;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import sample.contact.AddPermission;

public class AddPermissionValidator
implements Validator {
    public boolean supports(Class clazz) {
        return clazz.equals(AddPermission.class);
    }

    public void validate(Object obj, Errors errors) {
        int permission;
        AddPermission addPermission = (AddPermission)obj;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"permission", (String)"err.permission", (String)"Permission is required. *");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"recipient", (String)"err.recipient", (String)"Recipient is required. *");
        if (addPermission.getPermission() != null && (permission = addPermission.getPermission().intValue()) != BasePermission.ADMINISTRATION.getMask() && permission != BasePermission.READ.getMask() && permission != BasePermission.DELETE.getMask()) {
            errors.rejectValue("permission", "err.permission.invalid", "The indicated permission is invalid. *");
        }
        if (addPermission.getRecipient() != null && addPermission.getRecipient().length() > 100) {
            errors.rejectValue("recipient", "err.recipient.length", "The recipient is too long (maximum 100 characters). *");
        }
    }
}

