/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.util.List;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import sample.contact.Contact;
import sample.contact.ContactDao;
import sample.contact.ContactDaoSpring;

public class ContactDaoSpring
extends JdbcDaoSupport
implements ContactDao {
    private ContactDelete contactDelete;
    private ContactInsert contactInsert;
    private ContactUpdate contactUpdate;
    private ContactsAllQuery contactsAllQuery;
    private ContactsByIdQuery contactsByIdQuery;
    private PrincipalsAllQuery principalsAllQuery;
    private RolesAllQuery rolesAllQuery;

    public void create(Contact contact) {
        System.out.println("creating contact w/ id " + contact.getId() + " " + contact.getEmail());
        this.contactInsert.insert(contact);
    }

    public void delete(Long contactId) {
        this.contactDelete.delete(contactId);
    }

    public List findAll() {
        return this.contactsAllQuery.execute();
    }

    public List findAllPrincipals() {
        return this.principalsAllQuery.execute();
    }

    public List findAllRoles() {
        return this.rolesAllQuery.execute();
    }

    public Contact getById(Long id) {
        List list = this.contactsByIdQuery.execute(id.longValue());
        if (list.size() == 0) {
            return null;
        }
        return (Contact)list.get(0);
    }

    protected void initDao() throws Exception {
        this.contactInsert = new ContactInsert(this, this.getDataSource());
        this.contactUpdate = new ContactUpdate(this, this.getDataSource());
        this.contactDelete = new ContactDelete(this, this.getDataSource());
        this.contactsAllQuery = new ContactsAllQuery(this, this.getDataSource());
        this.principalsAllQuery = new PrincipalsAllQuery(this, this.getDataSource());
        this.rolesAllQuery = new RolesAllQuery(this, this.getDataSource());
        this.contactsByIdQuery = new ContactsByIdQuery(this, this.getDataSource());
    }

    private String makeObjectIdentity(Contact contact) {
        return contact.getClass().getName() + ":" + contact.getId();
    }

    public void update(Contact contact) {
        this.contactUpdate.update(contact);
    }
}

