/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.util.Assert;
import org.springframework.web.bind.RequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import sample.contact.Contact;
import sample.contact.ContactManager;

public class DeletePermissionController
implements Controller,
InitializingBean {
    private AclService aclService;
    private ContactManager contactManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contactManager, (String)"A ContactManager implementation is required");
        Assert.notNull((Object)this.aclService, (String)"An aclService implementation is required");
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int contactId = RequestUtils.getRequiredIntParameter((HttpServletRequest)request, (String)"contactId");
        String sid = RequestUtils.getRequiredStringParameter((HttpServletRequest)request, (String)"sid");
        int mask = RequestUtils.getRequiredIntParameter((HttpServletRequest)request, (String)"permission");
        Contact contact = this.contactManager.getById(new Long(contactId));
        PrincipalSid sidObject = new PrincipalSid(sid);
        Permission permission = BasePermission.buildFromMask((int)mask);
        this.contactManager.deletePermission(contact, (Sid)sidObject, permission);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("contact", contact);
        model.put("sid", sidObject);
        model.put("permission", permission);
        return new ModelAndView("deletePermission", "model", model);
    }

    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    public void setContactManager(ContactManager contact) {
        this.contactManager = contact;
    }
}

