/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.HasDisplayName;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.Value;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "decisions", "expression", "values"})
@XmlRootElement(name="OutputField", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"name", "displayName", "opType", "dataType", "targetField", "reportField", "resultFeature", "value", "ruleFeature", "algorithm", "rank", "rankBasis", "rankOrder", "isMultiValued", "segmentId", "finalResult", "extensions", "decisions", "expression", "values"})
public class OutputField
extends Field<OutputField>
implements HasDiscreteDomain<OutputField>,
HasDisplayName<OutputField>,
HasExpression<OutputField>,
HasExtensions<OutputField> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="name")
    private FieldName name;
    @XmlAttribute(name="displayName")
    @JsonProperty(value="displayName")
    private String displayName;
    @XmlAttribute(name="optype")
    @JsonProperty(value="optype")
    private OpType opType;
    @XmlAttribute(name="dataType", required=true)
    @Required(value=Version.PMML_4_3)
    @JsonProperty(value="dataType")
    private DataType dataType;
    @XmlAttribute(name="targetField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @Optional(value=Version.PMML_3_1)
    @JsonProperty(value="targetField")
    private FieldName targetField;
    @XmlAttribute(name="x-reportField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @org.jpmml.model.annotations.Extension
    @JsonProperty(value="x-reportField")
    private FieldName reportField;
    @XmlAttribute(name="feature")
    @JsonProperty(value="feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name="value")
    @JsonProperty(value="value")
    private String value;
    @XmlAttribute(name="ruleFeature")
    @Added(value=Version.PMML_4_0)
    @Deprecated(value=Version.PMML_4_2)
    @JsonProperty(value="ruleFeature")
    private RuleFeature ruleFeature;
    @XmlAttribute(name="algorithm")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="algorithm")
    private Algorithm algorithm;
    @XmlAttribute(name="rank")
    @JsonProperty(value="rank")
    private Integer rank;
    @XmlAttribute(name="rankBasis")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="rankBasis")
    private RankBasis rankBasis;
    @XmlAttribute(name="rankOrder")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="rankOrder")
    private RankOrder rankOrder;
    @XmlAttribute(name="isMultiValued")
    @Added(value=Version.PMML_4_0)
    @Deprecated(value=Version.PMML_4_2)
    @JsonProperty(value="isMultiValued")
    private String isMultiValued;
    @XmlAttribute(name="segmentId")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="segmentId")
    private String segmentId;
    @XmlAttribute(name="isFinalResult")
    @Added(value=Version.PMML_4_3)
    @JsonProperty(value="isFinalResult")
    private Boolean finalResult;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Decisions", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="Decisions")
    private Decisions decisions;
    @XmlElements(value={@XmlElement(name="Constant", namespace="http://www.dmg.org/PMML-4_3", type=Constant.class), @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_3", type=FieldRef.class), @XmlElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_3", type=NormContinuous.class), @XmlElement(name="NormDiscrete", namespace="http://www.dmg.org/PMML-4_3", type=NormDiscrete.class), @XmlElement(name="Discretize", namespace="http://www.dmg.org/PMML-4_3", type=Discretize.class), @XmlElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_3", type=MapValues.class), @XmlElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_3", type=TextIndex.class), @XmlElement(name="Apply", namespace="http://www.dmg.org/PMML-4_3", type=Apply.class), @XmlElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_3", type=Aggregate.class), @XmlElement(name="Lag", namespace="http://www.dmg.org/PMML-4_3", type=Lag.class)})
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="Expression")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Constant", value=Constant.class), @JsonSubTypes.Type(name="FieldRef", value=FieldRef.class), @JsonSubTypes.Type(name="NormContinuous", value=NormContinuous.class), @JsonSubTypes.Type(name="NormDiscrete", value=NormDiscrete.class), @JsonSubTypes.Type(name="Discretize", value=Discretize.class), @JsonSubTypes.Type(name="MapValues", value=MapValues.class), @JsonSubTypes.Type(name="TextIndex", value=TextIndex.class), @JsonSubTypes.Type(name="Apply", value=Apply.class), @JsonSubTypes.Type(name="Aggregate", value=Aggregate.class), @JsonSubTypes.Type(name="Lag", value=Lag.class)})
    private Expression expression;
    @XmlElement(name="Value", namespace="http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Extension
    @JsonProperty(value="Value")
    private List<Value> values;
    private static final Integer DEFAULT_RANK = 1;
    private static final Boolean DEFAULT_FINAL_RESULT = true;
    private static final long serialVersionUID = 67305485L;

    public OutputField() {
    }

    public OutputField(@Property(value="name") FieldName name, @Property(value="dataType") DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    @Override
    public FieldName getName() {
        return this.name;
    }

    @Override
    public OutputField setName(@Property(value="name") FieldName name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public OutputField setDisplayName(@Property(value="displayName") String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public OutputField setOpType(@Property(value="opType") OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public OutputField setDataType(@Property(value="dataType") DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public FieldName getTargetField() {
        return this.targetField;
    }

    public OutputField setTargetField(@Property(value="targetField") FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public FieldName getReportField() {
        return this.reportField;
    }

    public OutputField setReportField(@Property(value="reportField") FieldName reportField) {
        this.reportField = reportField;
        return this;
    }

    public ResultFeature getResultFeature() {
        if (this.resultFeature == null) {
            return ResultFeature.PREDICTED_VALUE;
        }
        return this.resultFeature;
    }

    public OutputField setResultFeature(@Property(value="resultFeature") ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public OutputField setValue(@Property(value="value") String value) {
        this.value = value;
        return this;
    }

    public RuleFeature getRuleFeature() {
        if (this.ruleFeature == null) {
            return RuleFeature.CONSEQUENT;
        }
        return this.ruleFeature;
    }

    public OutputField setRuleFeature(@Property(value="ruleFeature") RuleFeature ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    public Algorithm getAlgorithm() {
        if (this.algorithm == null) {
            return Algorithm.EXCLUSIVE_RECOMMENDATION;
        }
        return this.algorithm;
    }

    public OutputField setAlgorithm(@Property(value="algorithm") Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Integer getRank() {
        if (this.rank == null) {
            return DEFAULT_RANK;
        }
        return this.rank;
    }

    public OutputField setRank(@Property(value="rank") Integer rank) {
        this.rank = rank;
        return this;
    }

    public RankBasis getRankBasis() {
        if (this.rankBasis == null) {
            return RankBasis.CONFIDENCE;
        }
        return this.rankBasis;
    }

    public OutputField setRankBasis(@Property(value="rankBasis") RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    public RankOrder getRankOrder() {
        if (this.rankOrder == null) {
            return RankOrder.DESCENDING;
        }
        return this.rankOrder;
    }

    public OutputField setRankOrder(@Property(value="rankOrder") RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    public String getIsMultiValued() {
        if (this.isMultiValued == null) {
            return "0";
        }
        return this.isMultiValued;
    }

    public OutputField setIsMultiValued(@Property(value="isMultiValued") String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public OutputField setSegmentId(@Property(value="segmentId") String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public boolean isFinalResult() {
        if (this.finalResult == null) {
            return DEFAULT_FINAL_RESULT;
        }
        return this.finalResult;
    }

    public OutputField setFinalResult(@Property(value="finalResult") Boolean finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public OutputField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Decisions getDecisions() {
        return this.decisions;
    }

    public OutputField setDecisions(@Property(value="decisions") Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public OutputField setExpression(@Property(value="expression") Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean hasValues() {
        return this.values != null && this.values.size() > 0;
    }

    @Override
    public List<Value> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
        }
        return this.values;
    }

    @Override
    public OutputField addValues(Value ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getDecisions(), (Visitable)this.getExpression());
            }
            if (status == VisitorAction.CONTINUE && this.hasValues()) {
                status = PMMLObject.traverse(visitor, this.getValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum RuleFeature implements StringValue<RuleFeature>
    {
        ANTECEDENT("antecedent"),
        CONSEQUENT("consequent"),
        RULE("rule"),
        RULE_ID("ruleId"),
        CONFIDENCE("confidence"),
        SUPPORT("support"),
        LIFT("lift"),
        LEVERAGE("leverage"),
        AFFINITY("affinity");

        private final String value;

        private RuleFeature(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static RuleFeature fromValue(String v) {
            for (RuleFeature c : RuleFeature.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum RankOrder implements StringValue<RankOrder>
    {
        DESCENDING("descending"),
        ASCENDING("ascending");

        private final String value;

        private RankOrder(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static RankOrder fromValue(String v) {
            for (RankOrder c : RankOrder.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum RankBasis implements StringValue<RankBasis>
    {
        CONFIDENCE("confidence"),
        SUPPORT("support"),
        LIFT("lift"),
        LEVERAGE("leverage"),
        AFFINITY("affinity");

        private final String value;

        private RankBasis(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static RankBasis fromValue(String v) {
            for (RankBasis c : RankBasis.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Algorithm implements StringValue<Algorithm>
    {
        RECOMMENDATION("recommendation"),
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        RULE_ASSOCIATION("ruleAssociation");

        private final String value;

        private Algorithm(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Algorithm fromValue(String v) {
            for (Algorithm c : Algorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

