
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "textIndexNormalizations",
    "expression"
})
@Added((org.dmg.pmml.Version.PMML_4_2))
@JsonRootName("TextIndex")
@JsonPropertyOrder({
    "textField",
    "localTermWeights",
    "caseSensitive",
    "maxLevenshteinDistance",
    "countHits",
    "wordSeparatorCharacterRE",
    "tokenize",
    "extensions",
    "textIndexNormalizations",
    "expression"
})
public class TextIndex
    extends org.dmg.pmml.Expression
    implements HasExpression<TextIndex> , HasExtensions<TextIndex> , HasFieldReference<TextIndex>
{

    @XmlAttribute(name = "textField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("textField")
    private org.dmg.pmml.FieldName textField;
    @XmlAttribute(name = "localTermWeights")
    @JsonProperty("localTermWeights")
    private TextIndex.LocalTermWeights localTermWeights;
    @XmlAttribute(name = "isCaseSensitive")
    @JsonProperty("isCaseSensitive")
    private Boolean caseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name = "countHits")
    @JsonProperty("countHits")
    private TextIndex.CountHits countHits;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    @JsonProperty("wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name = "tokenize")
    @JsonProperty("tokenize")
    private Boolean tokenize;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TextIndexNormalization", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TextIndexNormalization")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Lag.class)
    })
    @JsonProperty("Expression")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Constant", value = org.dmg.pmml.Constant.class),
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "NormContinuous", value = org.dmg.pmml.NormContinuous.class),
        @JsonSubTypes.Type(name = "NormDiscrete", value = org.dmg.pmml.NormDiscrete.class),
        @JsonSubTypes.Type(name = "Discretize", value = org.dmg.pmml.Discretize.class),
        @JsonSubTypes.Type(name = "MapValues", value = org.dmg.pmml.MapValues.class),
        @JsonSubTypes.Type(name = "TextIndex", value = org.dmg.pmml.TextIndex.class),
        @JsonSubTypes.Type(name = "Apply", value = org.dmg.pmml.Apply.class),
        @JsonSubTypes.Type(name = "Aggregate", value = org.dmg.pmml.Aggregate.class),
        @JsonSubTypes.Type(name = "Lag", value = org.dmg.pmml.Lag.class)
    })
    private org.dmg.pmml.Expression expression;
    private final static Boolean DEFAULT_CASE_SENSITIVE = false;
    private final static Integer DEFAULT_MAX_LEVENSHTEIN_DISTANCE = new IntegerAdapter().unmarshal("0");
    private final static Boolean DEFAULT_TOKENIZE = true;
    private final static long serialVersionUID = 67371010L;

    public TextIndex() {
    }

    @ValueConstructor
    public TextIndex(
        @org.jpmml.model.annotations.Property("textField")
        org.dmg.pmml.FieldName textField,
        @org.jpmml.model.annotations.Property("expression")
        org.dmg.pmml.Expression expression) {
        this.textField = textField;
        this.expression = expression;
    }

    @Override
    public org.dmg.pmml.FieldName getField() {
        return getTextField();
    }

    @Override
    public TextIndex setField(org.dmg.pmml.FieldName field) {
        return setTextField(field);
    }

    public org.dmg.pmml.FieldName getTextField() {
        return textField;
    }

    public TextIndex setTextField(
        @org.jpmml.model.annotations.Property("textField")
        org.dmg.pmml.FieldName textField) {
        this.textField = textField;
        return this;
    }

    public TextIndex.LocalTermWeights getLocalTermWeights() {
        if (localTermWeights == null) {
            return TextIndex.LocalTermWeights.TERM_FREQUENCY;
        } else {
            return localTermWeights;
        }
    }

    public TextIndex setLocalTermWeights(
        @org.jpmml.model.annotations.Property("localTermWeights")
        TextIndex.LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public boolean isCaseSensitive() {
        if (caseSensitive == null) {
            return DEFAULT_CASE_SENSITIVE;
        } else {
            return caseSensitive;
        }
    }

    public TextIndex setCaseSensitive(
        @org.jpmml.model.annotations.Property("caseSensitive")
        Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Integer getMaxLevenshteinDistance() {
        if (maxLevenshteinDistance == null) {
            return DEFAULT_MAX_LEVENSHTEIN_DISTANCE;
        } else {
            return maxLevenshteinDistance;
        }
    }

    public TextIndex setMaxLevenshteinDistance(
        @org.jpmml.model.annotations.Property("maxLevenshteinDistance")
        Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public TextIndex.CountHits getCountHits() {
        if (countHits == null) {
            return TextIndex.CountHits.ALL_HITS;
        } else {
            return countHits;
        }
    }

    public TextIndex setCountHits(
        @org.jpmml.model.annotations.Property("countHits")
        TextIndex.CountHits countHits) {
        this.countHits = countHits;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        if (wordSeparatorCharacterRE == null) {
            return "\\s+";
        } else {
            return wordSeparatorCharacterRE;
        }
    }

    public TextIndex setWordSeparatorCharacterRE(
        @org.jpmml.model.annotations.Property("wordSeparatorCharacterRE")
        String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public boolean isTokenize() {
        if (tokenize == null) {
            return DEFAULT_TOKENIZE;
        } else {
            return tokenize;
        }
    }

    public TextIndex setTokenize(
        @org.jpmml.model.annotations.Property("tokenize")
        Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextIndex addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return ((this.textIndexNormalizations!= null)&&(this.textIndexNormalizations.size()> 0));
    }

    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (textIndexNormalizations == null) {
            textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization... textIndexNormalizations) {
        getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public org.dmg.pmml.Expression getExpression() {
        return expression;
    }

    @Override
    public TextIndex setExpression(
        @org.jpmml.model.annotations.Property("expression")
        org.dmg.pmml.Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTextIndexNormalizations()) {
                status = PMMLObject.traverse(visitor, getTextIndexNormalizations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CountHits
        implements StringValue<TextIndex.CountHits>
    {

        @XmlEnumValue("allHits")
        @JsonProperty("allHits")
        ALL_HITS("allHits"),
        @XmlEnumValue("bestHits")
        @JsonProperty("bestHits")
        BEST_HITS("bestHits");
        private final String value;

        CountHits(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TextIndex.CountHits fromValue(String v) {
            for (TextIndex.CountHits c: TextIndex.CountHits.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LocalTermWeights
        implements StringValue<TextIndex.LocalTermWeights>
    {

        @XmlEnumValue("termFrequency")
        @JsonProperty("termFrequency")
        TERM_FREQUENCY("termFrequency"),
        @XmlEnumValue("binary")
        @JsonProperty("binary")
        BINARY("binary"),
        @XmlEnumValue("logarithmic")
        @JsonProperty("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("augmentedNormalizedTermFrequency")
        @JsonProperty("augmentedNormalizedTermFrequency")
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");
        private final String value;

        LocalTermWeights(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TextIndex.LocalTermWeights fromValue(String v) {
            for (TextIndex.LocalTermWeights c: TextIndex.LocalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
