
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ComplexPartialScore", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "expression"
})
@Added((org.dmg.pmml.Version.PMML_4_2))
@JsonRootName("ComplexPartialScore")
@JsonPropertyOrder({
    "extensions",
    "expression"
})
public class ComplexPartialScore
    extends org.dmg.pmml.PMMLObject
    implements HasExpression<ComplexPartialScore> , HasExtensions<ComplexPartialScore>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Lag.class)
    })
    @JsonProperty("Expression")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Constant", value = org.dmg.pmml.Constant.class),
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "NormContinuous", value = org.dmg.pmml.NormContinuous.class),
        @JsonSubTypes.Type(name = "NormDiscrete", value = org.dmg.pmml.NormDiscrete.class),
        @JsonSubTypes.Type(name = "Discretize", value = org.dmg.pmml.Discretize.class),
        @JsonSubTypes.Type(name = "MapValues", value = org.dmg.pmml.MapValues.class),
        @JsonSubTypes.Type(name = "TextIndex", value = org.dmg.pmml.TextIndex.class),
        @JsonSubTypes.Type(name = "Apply", value = org.dmg.pmml.Apply.class),
        @JsonSubTypes.Type(name = "Aggregate", value = org.dmg.pmml.Aggregate.class),
        @JsonSubTypes.Type(name = "Lag", value = org.dmg.pmml.Lag.class)
    })
    private Expression expression;
    private final static long serialVersionUID = 67371010L;

    public ComplexPartialScore() {
    }

    @ValueConstructor
    public ComplexPartialScore(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComplexPartialScore addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Expression getExpression() {
        return expression;
    }

    @Override
    public ComplexPartialScore setExpression(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
