/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyMarshal;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"ConditionVariable"})
public class ConditionVariable
extends RubyObject {
    private final ConcurrentLinkedQueue<RubyThread> waiters = new ConcurrentLinkedQueue();

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static ConditionVariable newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        ConditionVariable result2 = new ConditionVariable(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public ConditionVariable(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass setup(RubyClass threadClass, RubyClass objectClass) {
        RubyClass cConditionVariable = threadClass.defineClassUnder("ConditionVariable", objectClass, ConditionVariable::new);
        cConditionVariable.undefineMethod("initialize_copy");
        cConditionVariable.setReifiedClass(ConditionVariable.class);
        cConditionVariable.defineAnnotatedMethods(ConditionVariable.class);
        objectClass.setConstant("ConditionVariable", cConditionVariable);
        return cConditionVariable;
    }

    @JRubyMethod(name={"wait"})
    public IRubyObject wait_ruby(ThreadContext context, IRubyObject m) {
        return this.wait_ruby(context, m, context.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wait"})
    public IRubyObject wait_ruby(ThreadContext context, IRubyObject m, IRubyObject t) {
        RubyThread thread2 = context.getThread();
        this.waiters.add(thread2);
        try {
            ConditionVariable.sites((ThreadContext)context).mutex_sleep.call(context, (IRubyObject)this, m, t);
        }
        finally {
            this.waiters.remove(thread2);
        }
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject broadcast(ThreadContext context) {
        this.waiters.removeIf(waiter -> {
            waiter.interrupt();
            return true;
        });
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject signal(ThreadContext context) {
        RubyThread waiter = this.waiters.poll();
        if (waiter != null) {
            waiter.interrupt();
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        return RubyMarshal.undumpable(context, this);
    }

    private static JavaSites.ConditionVariableSites sites(ThreadContext context) {
        return context.sites.ConditionVariable;
    }

    @Deprecated
    public IRubyObject wait_ruby(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.wait_ruby(context, args2[0]);
            }
            case 2: {
                return this.wait_ruby(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }
}

