/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipFile;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.JarResource;
import org.jruby.util.URLUtil;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JRubyClassLoader
extends ClassDefiningJRubyClassLoader {
    private static final Logger LOG;
    private Runnable unloader;
    private static volatile File tempDir;
    private final Map<String, URL> cachedJarPaths = new ConcurrentHashMap<String, URL>();
    private static final String TEMP_DIR_PREFIX = "jruby-";
    private static String tempDirName;

    public JRubyClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public void addURL(URL url) {
        if (url.toString().contains("!/") || !url.getProtocol().equals("file") && !url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            try {
                File f = File.createTempFile("jruby", new File(url.getFile()).getName(), JRubyClassLoader.getTempDir());
                try (FileOutputStream fileOut = new FileOutputStream(f);
                     InputStream urlIn = url.openStream();){
                    BufferedOutputStream out = new BufferedOutputStream(fileOut);
                    BufferedInputStream in = new BufferedInputStream(urlIn);
                    int i2 = ((InputStream)in).read();
                    while (i2 != -1) {
                        ((OutputStream)out).write(i2);
                        i2 = ((InputStream)in).read();
                    }
                    ((OutputStream)out).flush();
                    url = f.toURI().toURL();
                    this.cachedJarPaths.put(URLUtil.getPath(url), url);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("BUG: we can not copy embedded jar to temp directory", e);
            }
        }
        super.addURL(url);
    }

    private static synchronized File getTempDir() {
        if (tempDir != null) {
            return tempDir;
        }
        tempDir = new File(JRubyClassLoader.tempDir(), JRubyClassLoader.tempDirName());
        if (tempDir.mkdirs()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (File f : tempDir.listFiles()) {
                        try {
                            f.delete();
                        }
                        catch (Exception ex) {
                            LOG.debug(ex);
                        }
                    }
                    try {
                        tempDir.delete();
                    }
                    catch (Exception ex) {
                        LOG.info("failed to delete temp dir " + tempDir + " : " + ex, new Object[0]);
                    }
                }
            });
        }
        return tempDir;
    }

    private static String tempDirName() {
        String dirName = tempDirName;
        if (dirName != null) {
            return dirName;
        }
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            tempDirName = TEMP_DIR_PREFIX + processName.split("@")[0];
            return tempDirName;
        }
        catch (Throwable ex) {
            LOG.debug(ex);
            tempDirName = TEMP_DIR_PREFIX + Integer.toHexString(System.identityHashCode(JRubyClassLoader.class));
            return tempDirName;
        }
    }

    private static String tempDir() {
        String jrubyTmpdir = (String)Options.JI_NESTED_JAR_TMPDIR.load();
        if (jrubyTmpdir != null) {
            return jrubyTmpdir;
        }
        try {
            return System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException ex) {
            LOG.warn("could not access 'java.io.tmpdir' will use working directory", ex);
            return "";
        }
    }

    @Override
    public void close() {
        if (((Boolean)Options.JI_CLOSE_CLASSLOADER.load()).booleanValue()) {
            try {
                super.close();
            }
            catch (Exception ex) {
                LOG.debug(ex);
            }
        }
        try {
            this.getJDBCDriverUnloader().run();
        }
        catch (Exception ex) {
            LOG.debug(ex);
        }
        this.terminateJarIndexCacheEntries();
    }

    protected void terminateJarIndexCacheEntries() {
        this.cachedJarPaths.forEach((path2, url) -> {
            try {
                Object jarFile;
                URLConnection connection = url.openConnection();
                if (connection instanceof JarURLConnection) {
                    jarFile = ((JarURLConnection)connection).getJarFile();
                    try {
                        ((ZipFile)jarFile).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                JarResource.removeJarResource(path2);
                jarFile = new File((String)path2);
                ((File)jarFile).delete();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        });
    }

    @Deprecated
    public synchronized Runnable getJDBCDriverUnloader() {
        if (this.unloader == null) {
            try {
                int bytesRead;
                InputStream unloaderStream = this.getClass().getResourceAsStream("/org/jruby/util/JDBCDriverUnloader.class");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = unloaderStream.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                Class<?> unloaderClass = this.defineClass("org.jruby.util.JDBCDriverUnloader", baos.toByteArray());
                this.unloader = (Runnable)unloaderClass.newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.unloader;
    }

    static {
        JRubyClassLoader.registerAsParallelCapable();
        LOG = LoggerFactory.getLogger(JRubyClassLoader.class);
    }
}

