/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class ThreadLibrary
implements Library {
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        Mutex.setup(runtime2);
        ConditionVariable.setup(runtime2);
        Queue.setup(runtime2);
        SizedQueue.setup(runtime2);
    }

    @JRubyClass(name={"SizedQueue"}, parent="Queue")
    public static class SizedQueue
    extends Queue {
        private int capacity = 1;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            SizedQueue result = new SizedQueue(context.getRuntime(), (RubyClass)recv2);
            result.callInit(args2, block);
            return result;
        }

        public SizedQueue(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        public static void setup(Ruby runtime2) {
            RubyClass cSizedQueue = runtime2.defineClass("SizedQueue", runtime2.fastGetClass("Queue"), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                    return new SizedQueue(runtime2, klass);
                }
            });
            cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear(ThreadContext context) {
            super.clear(context);
            this.notifyAll();
            return context.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized RubyNumeric max(ThreadContext context) {
            return RubyNumeric.int2fix(context.getRuntime(), this.capacity);
        }

        @JRubyMethod(name={"max=", "initialize"})
        public synchronized IRubyObject max_set(ThreadContext context, IRubyObject arg2) {
            int new_capacity = RubyNumeric.fix2int(arg2);
            if (new_capacity <= 0) {
                context.getRuntime().newArgumentError("queue size must be positive");
            }
            int difference = new_capacity > this.capacity ? new_capacity - this.capacity : 0;
            this.capacity = new_capacity;
            if (difference > 0) {
                this.notifyAll();
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(ThreadContext context, IRubyObject[] args2) {
            IRubyObject result = super.pop(context, args2);
            this.notifyAll();
            return result;
        }

        @JRubyMethod(name={"push", "<<"})
        public synchronized IRubyObject push(ThreadContext context, IRubyObject value2) {
            if (this.java_length() >= (long)this.capacity) {
                ++this.numWaiting;
                while (this.java_length() >= (long)this.capacity) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                --this.numWaiting;
            }
            super.push(context, value2);
            this.notifyAll();
            return context.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Queue"})
    public static class Queue
    extends RubyObject {
        private LinkedList entries = new LinkedList();
        protected volatile int numWaiting = 0;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Queue result = new Queue(context.getRuntime(), (RubyClass)recv2);
            result.callInit(args2, block);
            return result;
        }

        public Queue(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        public static void setup(Ruby runtime2) {
            RubyClass cQueue = runtime2.defineClass("Queue", runtime2.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                    return new Queue(runtime2, klass);
                }
            });
            cQueue.defineAnnotatedMethods(Queue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear(ThreadContext context) {
            this.entries.clear();
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"empty?"})
        public synchronized RubyBoolean empty_p(ThreadContext context) {
            return context.getRuntime().newBoolean(this.entries.size() == 0);
        }

        @JRubyMethod(name={"length", "size"})
        public synchronized RubyNumeric length(ThreadContext context) {
            return RubyNumeric.int2fix(context.getRuntime(), this.entries.size());
        }

        protected synchronized long java_length() {
            return this.entries.size();
        }

        @JRubyMethod
        public RubyNumeric num_waiting(ThreadContext context) {
            return context.getRuntime().newFixnum(this.numWaiting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(ThreadContext context, IRubyObject[] args2) {
            boolean should_block = true;
            if (Arity.checkArgumentCount(context.getRuntime(), args2, 0, 1) == 1) {
                boolean bl = should_block = !args2[0].isTrue();
            }
            if (!should_block && this.entries.size() == 0) {
                throw new RaiseException(context.getRuntime(), context.getRuntime().getThreadError(), "queue empty", false);
            }
            ++this.numWaiting;
            while (this.entries.size() == 0) {
                try {
                    context.getThread().enterSleep();
                    this.wait();
                }
                catch (InterruptedException e) {}
                continue;
                finally {
                    context.getThread().exitSleep();
                }
            }
            --this.numWaiting;
            return (IRubyObject)this.entries.removeFirst();
        }

        @JRubyMethod(name={"push", "<<", "enq"})
        public synchronized IRubyObject push(ThreadContext context, IRubyObject value2) {
            this.entries.addLast(value2);
            this.notify();
            return context.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"ConditionVariable"})
    public static class ConditionVariable
    extends RubyObject {
        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static ConditionVariable newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            ConditionVariable result = new ConditionVariable(context.getRuntime(), (RubyClass)recv2);
            result.callInit(args2, block);
            return result;
        }

        public ConditionVariable(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        public static void setup(Ruby runtime2) {
            RubyClass cConditionVariable = runtime2.defineClass("ConditionVariable", runtime2.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                    return new ConditionVariable(runtime2, klass);
                }
            });
            cConditionVariable.defineAnnotatedMethods(ConditionVariable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"wait"}, required=1, optional=1)
        public IRubyObject wait_ruby(ThreadContext context, IRubyObject[] args2) throws InterruptedException {
            if (args2.length < 1) {
                throw context.getRuntime().newArgumentError(args2.length, 1);
            }
            if (args2.length > 2) {
                throw context.getRuntime().newArgumentError(args2.length, 2);
            }
            if (!(args2[0] instanceof Mutex)) {
                throw context.getRuntime().newTypeError(args2[0], context.getRuntime().fastGetClass("Mutex"));
            }
            Mutex mutex = (Mutex)args2[0];
            Double timeout2 = null;
            if (args2.length > 1 && !args2[1].isNil()) {
                timeout2 = args2[1].convertToFloat().getDoubleValue();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean success2 = false;
            try {
                ConditionVariable conditionVariable = this;
                synchronized (conditionVariable) {
                    mutex.unlock(context);
                    try {
                        success2 = context.getThread().wait_timeout(this, timeout2);
                    }
                    finally {
                        if (!success2) {
                            this.notify();
                        }
                    }
                }
            }
            finally {
                mutex.lock(context);
            }
            if (timeout2 != null) {
                return context.getRuntime().newBoolean(success2);
            }
            return this;
        }

        @JRubyMethod
        public synchronized IRubyObject broadcast(ThreadContext context) {
            this.notifyAll();
            return this;
        }

        @JRubyMethod
        public synchronized IRubyObject signal(ThreadContext context) {
            this.notify();
            return this;
        }
    }

    @JRubyClass(name={"Mutex"})
    public static class Mutex
    extends RubyObject {
        private RubyThread owner = null;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static Mutex newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Mutex result = new Mutex(context.getRuntime(), (RubyClass)recv2);
            result.callInit(args2, block);
            return result;
        }

        public Mutex(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        public static void setup(Ruby runtime2) {
            RubyClass cMutex = runtime2.defineClass("Mutex", runtime2.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                    return new Mutex(runtime2, klass);
                }
            });
            cMutex.defineAnnotatedMethods(Mutex.class);
        }

        @JRubyMethod(name={"locked?"})
        public synchronized RubyBoolean locked_p(ThreadContext context) {
            return context.getRuntime().newBoolean(this.owner != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public RubyBoolean try_lock(ThreadContext context) throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner != null) {
                    return context.getRuntime().getFalse();
                }
                this.lock(context);
            }
            return context.getRuntime().getTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(frame=true)
        public IRubyObject lock(ThreadContext context) throws InterruptedException {
            try {
                context.getThread().enterSleep();
                Mutex mutex = this;
                synchronized (mutex) {
                    try {
                        if (this.owner == context.getThread()) {
                            throw context.getRuntime().newThreadError("Mutex relocking by same thread");
                        }
                        while (this.owner != null) {
                            this.wait();
                        }
                        this.owner = context.getThread();
                    }
                    catch (InterruptedException ex) {
                        if (this.owner == null) {
                            this.notify();
                        }
                        throw ex;
                    }
                }
            }
            finally {
                context.getThread().exitSleep();
            }
            return this;
        }

        @JRubyMethod
        public synchronized RubyBoolean unlock(ThreadContext context) {
            if (this.owner != null) {
                this.owner = null;
                this.notify();
                return context.getRuntime().getTrue();
            }
            return context.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject synchronize(ThreadContext context, Block block) throws InterruptedException {
            try {
                this.lock(context);
                IRubyObject iRubyObject = block.yield(context, null);
                return iRubyObject;
            }
            finally {
                this.unlock(context);
            }
        }
    }
}

