/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.SkipUndoDateTimeField;

public final class BuddhistChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3474595157769370126L;
    public static final int BE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("BE");
    private static final int BUDDHIST_OFFSET = 543;
    private static final Map<DateTimeZone, BuddhistChronology> cCache = new HashMap<DateTimeZone, BuddhistChronology>();
    private static final BuddhistChronology INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    public static synchronized BuddhistChronology getInstance(DateTimeZone dateTimeZone) {
        BuddhistChronology buddhistChronology;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((buddhistChronology = cCache.get(dateTimeZone)) == null) {
            buddhistChronology = new BuddhistChronology(GJChronology.getInstance(dateTimeZone, null), null);
            DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, buddhistChronology);
            buddhistChronology = new BuddhistChronology(LimitChronology.getInstance(buddhistChronology, dateTime, null), "");
            cCache.put(dateTimeZone, buddhistChronology);
        }
        return buddhistChronology;
    }

    private BuddhistChronology(Chronology chronology, Object object) {
        super(chronology, object);
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        return chronology == null ? BuddhistChronology.getInstanceUTC() : BuddhistChronology.getInstance(chronology.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(dateTimeZone);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return "Buddhist".hashCode() * 11 + this.getZone().hashCode();
    }

    public String toString() {
        String string2 = "BuddhistChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string2 = string2 + '[' + dateTimeZone.getID() + ']';
        }
        return string2;
    }

    protected void assemble(AssembledChronology.Fields fields2) {
        if (this.getParam() == null) {
            DateTimeField dateTimeField = fields2.year;
            fields2.year = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = fields2.yearOfEra;
            fields2.yearOfEra = new DelegatedDateTimeField(fields2.year, DateTimeFieldType.yearOfEra());
            dateTimeField = fields2.weekyear;
            fields2.weekyear = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = new OffsetDateTimeField(fields2.yearOfEra, 99);
            fields2.centuryOfEra = new DividedDateTimeField(dateTimeField, DateTimeFieldType.centuryOfEra(), 100);
            dateTimeField = new RemainderDateTimeField((DividedDateTimeField)fields2.centuryOfEra);
            fields2.yearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.yearOfCentury(), 1);
            dateTimeField = new RemainderDateTimeField(fields2.weekyear, DateTimeFieldType.weekyearOfCentury(), 100);
            fields2.weekyearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.weekyearOfCentury(), 1);
            fields2.era = ERA_FIELD;
        }
    }
}

