/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.ReferenceType;
import java.util.List;
import org.jsonschema2pojo.exception.GenerationException;

public class TypeUtil {
    public static JClass resolveType(JPackage _package, String typeDefinition) {
        try {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)JavaParser.parseBodyDeclaration((String)(typeDefinition + " foo;"));
            ClassOrInterfaceType c = (ClassOrInterfaceType)fieldDeclaration.getType().getChildrenNodes().get(0);
            return TypeUtil.buildClass(_package, c, 0);
        }
        catch (ParseException e) {
            throw new GenerationException(e);
        }
    }

    private static JClass buildClass(JPackage _package, ClassOrInterfaceType c, int arrayCount) {
        JClass _class;
        String packagePrefix = c.getScope() != null ? c.getScope().toString() + "." : "";
        try {
            _class = _package.owner().ref(Thread.currentThread().getContextClassLoader().loadClass(packagePrefix + c.getName()));
        }
        catch (ClassNotFoundException e) {
            _class = _package.owner().ref(packagePrefix + c.getName());
        }
        for (int i = 0; i < arrayCount; ++i) {
            _class = _class.array();
        }
        List typeArgs = c.getTypeArgs();
        if (typeArgs != null && typeArgs.size() > 0) {
            JClass[] genericArgumentClasses = new JClass[typeArgs.size()];
            for (int i = 0; i < typeArgs.size(); ++i) {
                genericArgumentClasses[i] = TypeUtil.buildClass(_package, (ClassOrInterfaceType)((ReferenceType)typeArgs.get(i)).getType(), ((ReferenceType)typeArgs.get(i)).getArrayCount());
            }
            _class = _class.narrow(genericArgumentClasses);
        }
        return _class;
    }
}

