/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class PropertyRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected PropertyRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JDefinedClass jclass, Schema schema) {
        String propertyName = this.ruleFactory.getNameHelper().getPropertyName(nodeName, node);
        JType propertyType = this.ruleFactory.getSchemaRule().apply(nodeName, node, (JClassContainer)jclass, schema);
        node = this.resolveRefs(node, schema);
        int accessModifier = this.ruleFactory.getGenerationConfig().isIncludeAccessors() ? 4 : 1;
        JFieldVar field = jclass.field(accessModifier, propertyType, propertyName);
        this.propertyAnnotations(nodeName, node, schema, (JDocCommentable)field);
        this.formatAnnotation(field, node);
        this.ruleFactory.getAnnotator().propertyField(field, jclass, nodeName, node);
        if (this.ruleFactory.getGenerationConfig().isIncludeAccessors()) {
            JMethod getter = this.addGetter(jclass, field, nodeName, node);
            this.ruleFactory.getAnnotator().propertyGetter(getter, nodeName);
            this.propertyAnnotations(nodeName, node, schema, (JDocCommentable)getter);
            JMethod setter = this.addSetter(jclass, field, nodeName, node);
            this.ruleFactory.getAnnotator().propertySetter(setter, nodeName);
            this.propertyAnnotations(nodeName, node, schema, (JDocCommentable)setter);
        }
        if (this.ruleFactory.getGenerationConfig().isGenerateBuilders()) {
            this.addBuilder(jclass, field);
        }
        if (node.has("pattern")) {
            this.ruleFactory.getPatternRule().apply(nodeName, node.get("pattern"), field, schema);
        }
        this.ruleFactory.getDefaultRule().apply(nodeName, node.get("default"), field, schema);
        this.ruleFactory.getMinimumMaximumRule().apply(nodeName, node, field, schema);
        this.ruleFactory.getMinItemsMaxItemsRule().apply(nodeName, node, field, schema);
        this.ruleFactory.getMinLengthMaxLengthRule().apply(nodeName, node, field, schema);
        if (this.isObject(node) || this.isArray(node)) {
            this.ruleFactory.getValidRule().apply(nodeName, node, field, schema);
        }
        return jclass;
    }

    private void propertyAnnotations(String nodeName, JsonNode node, Schema schema, JDocCommentable generatedJavaConstruct) {
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), generatedJavaConstruct, schema);
        }
        if (node.has("javaName")) {
            this.ruleFactory.getJavaNameRule().apply(nodeName, node.get("javaName"), generatedJavaConstruct, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), generatedJavaConstruct, schema);
        }
        if (node.has("required")) {
            this.ruleFactory.getRequiredRule().apply(nodeName, node.get("required"), generatedJavaConstruct, schema);
        } else {
            this.ruleFactory.getNotRequiredRule().apply(nodeName, node.get("required"), generatedJavaConstruct, schema);
        }
    }

    private void formatAnnotation(JFieldVar field, JsonNode node) {
        String format = node.path("format").asText();
        if ("date-time".equalsIgnoreCase(format)) {
            this.ruleFactory.getAnnotator().dateField(field, node);
        }
    }

    private JsonNode resolveRefs(JsonNode node, Schema parent) {
        if (node.has("$ref")) {
            Schema refSchema = this.ruleFactory.getSchemaStore().create(parent, node.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            JsonNode refNode = refSchema.getContent();
            return this.resolveRefs(refNode, parent);
        }
        return node;
    }

    private boolean isObject(JsonNode node) {
        return node.path("type").asText().equals("object");
    }

    private boolean isArray(JsonNode node) {
        return node.path("type").asText().equals("array");
    }

    private JMethod addGetter(JDefinedClass c, JFieldVar field, String jsonPropertyName, JsonNode node) {
        JMethod getter = c.method(1, field.type(), this.getGetterName(jsonPropertyName, field.type(), node));
        JBlock body = getter.body();
        body._return((JExpression)field);
        return getter;
    }

    private JMethod addSetter(JDefinedClass c, JFieldVar field, String jsonPropertyName, JsonNode node) {
        JMethod setter = c.method(1, Void.TYPE, this.getSetterName(jsonPropertyName, node));
        JVar param = setter.param(field.type(), field.name());
        JBlock body = setter.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        return setter;
    }

    private JMethod addBuilder(JDefinedClass c, JFieldVar field) {
        JMethod builder = c.method(1, (JType)c, this.getBuilderName(field.name()));
        JVar param = builder.param(field.type(), field.name());
        JBlock body = builder.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        body._return(JExpr._this());
        return builder;
    }

    private String getBuilderName(String propertyName) {
        propertyName = this.ruleFactory.getNameHelper().replaceIllegalCharacters(propertyName);
        return "with" + StringUtils.capitalize((String)this.ruleFactory.getNameHelper().capitalizeTrailingWords(propertyName));
    }

    private String getSetterName(String propertyName, JsonNode node) {
        return this.ruleFactory.getNameHelper().getSetterName(propertyName, node);
    }

    private String getGetterName(String propertyName, JType type, JsonNode node) {
        return this.ruleFactory.getNameHelper().getGetterName(propertyName, type, node);
    }
}

