/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import android.os.Parcel;
import android.os.Parcelable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.util.Models;

public class ParcelableHelper {
    public void addWriteToParcel(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Void.TYPE, "writeToParcel");
        JVar dest = method.param(Parcel.class, "dest");
        method.param(Integer.TYPE, "flags");
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                method.body().invoke((JExpression)dest, "writeList").arg((JExpression)f);
                continue;
            }
            method.body().invoke((JExpression)dest, "writeValue").arg((JExpression)f);
        }
    }

    public void addDescribeContents(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Integer.TYPE, "describeContents");
        method.body()._return(JExpr.lit((int)0));
    }

    public void addCreator(JDefinedClass jclass) {
        JClass creatorType = jclass.owner().ref(Parcelable.Creator.class).narrow((JClass)jclass);
        JDefinedClass creatorClass = jclass.owner().anonymousClass(creatorType);
        this.addCreateFromParcel(jclass, creatorClass);
        this.addNewArray(jclass, creatorClass);
        JFieldVar creatorField = jclass.field(25, (JType)creatorType, "CREATOR");
        creatorField.init((JExpression)JExpr._new((JClass)creatorClass));
    }

    private void addNewArray(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod newArray = creatorClass.method(1, (JType)jclass.array(), "newArray");
        newArray.param(Integer.TYPE, "size");
        newArray.body()._return(JExpr.direct((String)("new " + jclass.name() + "[size]")));
    }

    private void addCreateFromParcel(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod createFromParcel = creatorClass.method(1, (JType)jclass, "createFromParcel");
        JVar in = createFromParcel.param(Parcel.class, "in");
        JVar instance = createFromParcel.body().decl((JType)jclass, "instance", (JExpression)JExpr._new((JClass)jclass));
        Models.suppressWarnings(createFromParcel, "unchecked");
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                createFromParcel.body().invoke((JExpression)in, "readList").arg((JExpression)instance.ref((JVar)f)).arg(JExpr.direct((String)(this.getListType(f.type()) + ".class.getClassLoader()")));
                continue;
            }
            createFromParcel.body().assign((JAssignmentTarget)instance.ref((JVar)f), (JExpression)JExpr.cast((JType)f.type(), (JExpression)in.invoke("readValue").arg(JExpr.direct((String)(f.type().erasure().name() + ".class.getClassLoader()")))));
        }
        createFromParcel.body()._return((JExpression)instance);
    }

    private String getListType(JType jType) {
        String typeName = jType.fullName();
        return StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)typeName, (String)"<"), (String)">");
    }
}

