/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.AbstractAnnotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.rules.FormatRule;

public class Jackson2Annotator
extends AbstractAnnotator {
    private final JsonInclude.Include inclusionLevel;

    public Jackson2Annotator(GenerationConfig generationConfig) {
        super(generationConfig);
        switch (generationConfig.getInclusionLevel()) {
            case ALWAYS: {
                this.inclusionLevel = JsonInclude.Include.ALWAYS;
                break;
            }
            case NON_ABSENT: {
                this.inclusionLevel = JsonInclude.Include.NON_ABSENT;
                break;
            }
            case NON_DEFAULT: {
                this.inclusionLevel = JsonInclude.Include.NON_DEFAULT;
                break;
            }
            case NON_EMPTY: {
                this.inclusionLevel = JsonInclude.Include.NON_EMPTY;
                break;
            }
            case NON_NULL: {
                this.inclusionLevel = JsonInclude.Include.NON_NULL;
                break;
            }
            case USE_DEFAULTS: {
                this.inclusionLevel = JsonInclude.Include.USE_DEFAULTS;
                break;
            }
            default: {
                this.inclusionLevel = JsonInclude.Include.NON_NULL;
            }
        }
    }

    @Override
    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            annotationValue.param((String)properties.next());
        }
    }

    @Override
    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
        clazz.annotate(JsonInclude.class).param("value", (Enum)this.inclusionLevel);
    }

    @Override
    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        field.annotate(JsonProperty.class).param("value", propertyName);
        if (field.type().erasure().equals(field.type().owner().ref(Set.class))) {
            field.annotate(JsonDeserialize.class).param("as", LinkedHashSet.class);
        }
        if (propertyNode.has("javaJsonView")) {
            field.annotate(JsonView.class).param("value", (JType)field.type().owner().ref(propertyNode.get("javaJsonView").asText()));
        }
        if (propertyNode.has("description")) {
            field.annotate(JsonPropertyDescription.class).param("value", propertyNode.get("description").asText());
        }
    }

    @Override
    public void propertyGetter(JMethod getter, String propertyName) {
        getter.annotate(JsonProperty.class).param("value", propertyName);
    }

    @Override
    public void propertySetter(JMethod setter, String propertyName) {
        setter.annotate(JsonProperty.class).param("value", propertyName);
    }

    @Override
    public void anyGetter(JMethod getter) {
        getter.annotate(JsonAnyGetter.class);
    }

    @Override
    public void anySetter(JMethod setter) {
        setter.annotate(JsonAnySetter.class);
    }

    @Override
    public void enumCreatorMethod(JMethod creatorMethod) {
        creatorMethod.annotate(JsonCreator.class);
    }

    @Override
    public void enumValueMethod(JMethod valueMethod) {
        valueMethod.annotate(JsonValue.class);
    }

    @Override
    public void enumConstant(JEnumConstant constant, String value) {
    }

    @Override
    public boolean isAdditionalPropertiesSupported() {
        return true;
    }

    @Override
    public void additionalPropertiesField(JFieldVar field, JDefinedClass clazz, String propertyName) {
        field.annotate(JsonIgnore.class);
    }

    @Override
    public void dateField(JFieldVar field, JsonNode node) {
        String pattern = null;
        if (node.has("customDatePattern")) {
            pattern = node.get("customDatePattern").asText();
        } else if (node.has("customPattern")) {
            pattern = node.get("customPattern").asText();
        } else if (StringUtils.isNotEmpty((CharSequence)this.getGenerationConfig().getCustomDatePattern())) {
            pattern = this.getGenerationConfig().getCustomDatePattern();
        } else if (this.getGenerationConfig().isFormatDates()) {
            pattern = FormatRule.ISO_8601_DATE_FORMAT;
        }
        if (pattern != null && !field.type().fullName().equals("java.lang.String")) {
            field.annotate(JsonFormat.class).param("shape", (Enum)JsonFormat.Shape.STRING).param("pattern", pattern);
        }
    }

    @Override
    public void dateTimeField(JFieldVar field, JsonNode node) {
        String timezone = node.has("customTimezone") ? node.get("customTimezone").asText() : "UTC";
        String pattern = null;
        if (node.has("customDateTimePattern")) {
            pattern = node.get("customDateTimePattern").asText();
        } else if (node.has("customPattern")) {
            pattern = node.get("customPattern").asText();
        } else if (StringUtils.isNotEmpty((CharSequence)this.getGenerationConfig().getCustomDateTimePattern())) {
            pattern = this.getGenerationConfig().getCustomDateTimePattern();
        } else if (this.getGenerationConfig().isFormatDateTimes()) {
            pattern = FormatRule.ISO_8601_DATETIME_FORMAT;
        }
        if (pattern != null && !field.type().fullName().equals("java.lang.String")) {
            field.annotate(JsonFormat.class).param("shape", (Enum)JsonFormat.Shape.STRING).param("pattern", pattern).param("timezone", timezone);
        }
    }
}

