/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class NotRequiredRule
implements Rule<JDocCommentable, JDocCommentable> {
    public static final String NOT_REQUIRED_COMMENT_TEXT = "\n(Can be null)";
    private final RuleFactory ruleFactory;

    protected NotRequiredRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDocCommentable apply(String nodeName, JsonNode node, JDocCommentable generatableType, Schema schema) {
        JsonNode requiredArray = schema.getContent().get("required");
        if (requiredArray != null) {
            Iterator iterator = requiredArray.elements();
            while (iterator.hasNext()) {
                String requiredArrayItem = ((JsonNode)iterator.next()).asText();
                if (!nodeName.equals(requiredArrayItem)) continue;
                return generatableType;
            }
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr305Annotations() && generatableType instanceof JFieldVar) {
            generatableType.javadoc().append((Object)NOT_REQUIRED_COMMENT_TEXT);
            ((JFieldVar)generatableType).annotate(Nullable.class);
        }
        return generatableType;
    }
}

