/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.util.Objects;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.ReflectionHelper;

public class BuilderRule
implements Rule<JDefinedClass, JDefinedClass> {
    private RuleFactory ruleFactory;
    private ReflectionHelper reflectionHelper;

    BuilderRule(RuleFactory ruleFactory, ReflectionHelper reflectionHelper) {
        this.ruleFactory = ruleFactory;
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass instanceClass, Schema currentSchema) {
        JDefinedClass concreteBuilderClass;
        JDefinedClass builderClass;
        try {
            String concreteBuilderClassName = this.ruleFactory.getNameHelper().getBuilderClassName((JClass)instanceClass);
            String builderClassName = this.ruleFactory.getNameHelper().getBaseBuilderClassName((JClass)instanceClass);
            builderClass = instanceClass._class(49, builderClassName);
            concreteBuilderClass = instanceClass._class(17, concreteBuilderClassName);
            concreteBuilderClass._extends(builderClass.narrow((JClass)instanceClass));
        }
        catch (JClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        JDefinedClass parentBuilderClass = null;
        JClass parentClass = instanceClass._extends();
        if (!(parentClass.isPrimitive() || this.reflectionHelper.isFinal((JType)parentClass) || Objects.equals(parentClass.fullName(), "java.lang.Object"))) {
            parentBuilderClass = this.reflectionHelper.getBaseBuilderClass(parentClass);
        }
        String builderTypeParameterName = this.ruleFactory.getNameHelper().getBuilderTypeParameterName(instanceClass);
        JTypeVar instanceType = builderClass.generify(builderTypeParameterName, (JClass)instanceClass);
        if (parentBuilderClass == null) {
            JFieldVar instanceField = builderClass.field(2, (JType)instanceType, "instance");
            JMethod buildMethod = builderClass.method(1, (JType)instanceType, "build");
            JBlock body = buildMethod.body();
            JVar result = body.decl((JType)instanceType, "result");
            body.assign((JAssignmentTarget)result, (JExpression)JExpr._this().ref((JVar)instanceField));
            body.assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), JExpr._null());
            body._return((JExpression)result);
            this.generateNoArgsBuilderConstructors(instanceClass, builderClass, concreteBuilderClass);
        } else {
            builderClass._extends(parentBuilderClass.narrow(parentBuilderClass.owner().ref(builderTypeParameterName)));
            JMethod buildMethod = builderClass.method(1, (JType)instanceType, "build");
            buildMethod.annotate(Override.class);
            JBlock body = buildMethod.body();
            body._return((JExpression)JExpr._super().invoke("build"));
            this.generateNoArgsBuilderConstructors(instanceClass, builderClass, concreteBuilderClass);
        }
        return builderClass;
    }

    private void generateNoArgsBuilderConstructors(JDefinedClass instanceClass, JDefinedClass baseBuilderClass, JDefinedClass builderClass) {
        this.generateNoArgsBaseBuilderConstructor(instanceClass, baseBuilderClass, builderClass);
        this.generateNoArgsBuilderConstructor(instanceClass, baseBuilderClass, builderClass);
    }

    private void generateNoArgsBuilderConstructor(JDefinedClass instanceClass, JDefinedClass baseBuilderClass, JDefinedClass builderClass) {
        JMethod noArgsConstructor = builderClass.constructor(1);
        JBlock constructorBlock = noArgsConstructor.body();
        if (!(baseBuilderClass.isPrimitive() || this.reflectionHelper.isFinal((JType)baseBuilderClass) || Objects.equals(baseBuilderClass.fullName(), "java.lang.Object"))) {
            constructorBlock.invoke("super");
        }
    }

    private void generateNoArgsBaseBuilderConstructor(JDefinedClass instanceClass, JDefinedClass builderClass, JDefinedClass concreteBuilderClass) {
        JMethod noArgsConstructor = builderClass.constructor(1);
        JAnnotationUse warningSuppression = noArgsConstructor.annotate(SuppressWarnings.class);
        warningSuppression.param("value", "unchecked");
        JBlock constructorBlock = noArgsConstructor.body();
        JFieldVar instanceField = this.reflectionHelper.searchClassAndSuperClassesForField("instance", builderClass);
        JClass parentClass = builderClass._extends();
        if (!(parentClass.isPrimitive() || this.reflectionHelper.isFinal((JType)parentClass) || Objects.equals(parentClass.fullName(), "java.lang.Object"))) {
            constructorBlock.invoke("super");
        }
        constructorBlock.directStatement("// Skip initialization when called from subclass");
        JInvocation comparison = JExpr._this().invoke("getClass").invoke("equals").arg(JExpr.dotclass((JClass)concreteBuilderClass));
        JConditional ifNotSubclass = constructorBlock._if((JExpression)comparison);
        ifNotSubclass._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)instanceField), (JExpression)JExpr.cast((JType)instanceField.type(), (JExpression)JExpr._new((JClass)instanceClass)));
    }
}

