/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonPointerUtils {
    private static Map<String, String> SUBSTITUTIONS = new LinkedHashMap<String, String>(){
        {
            this.put("~", "~0");
            this.put("/", "~1");
            this.put("#", "~2");
            this.put(".", "~3");
            this.put("?", "~4");
        }
    };

    public static String encodeReferenceToken(String s) {
        String encoded = s;
        for (Map.Entry<String, String> sub : SUBSTITUTIONS.entrySet()) {
            encoded = encoded.replace(sub.getKey(), sub.getValue());
        }
        return encoded;
    }

    public static String decodeReferenceToken(String s) {
        String decoded = s;
        ArrayList<String> reverseOrderedKeys = new ArrayList<String>(SUBSTITUTIONS.keySet());
        Collections.reverse(reverseOrderedKeys);
        for (String key : reverseOrderedKeys) {
            decoded = decoded.replace(SUBSTITUTIONS.get(key), key);
        }
        return decoded;
    }
}

