/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.Size;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class MinLengthMaxLengthRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected MinLengthMaxLengthRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && (node.has("minLength") || node.has("maxLength")) && this.isApplicableType(field)) {
            Class sizeClass = this.ruleFactory.getGenerationConfig().isUseJakartaValidation() ? jakarta.validation.constraints.Size.class : Size.class;
            JAnnotationUse annotation = field.annotate(sizeClass);
            if (node.has("minLength")) {
                annotation.param("min", node.get("minLength").asInt());
            }
            if (node.has("maxLength")) {
                annotation.param("max", node.get("maxLength").asInt());
            }
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass;
            String typeName = field.type().boxify().fullName();
            int genericsPos = typeName.indexOf(60);
            if (genericsPos > -1) {
                typeName = typeName.substring(0, genericsPos);
            }
            return String.class.isAssignableFrom(fieldClass = Class.forName(typeName)) || Collection.class.isAssignableFrom(fieldClass) || Map.class.isAssignableFrom(fieldClass) || Array.class.isAssignableFrom(fieldClass) || field.type().isArray();
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

