/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JavaVersion {
    private static final Pattern JAVA_VERSION_1_X = Pattern.compile("(^1.\\d+)");
    private static final Pattern JAVA_VERSION_X = Pattern.compile("(^\\d+)");

    public static String parse(String version) {
        if (StringUtils.startsWith((CharSequence)version, (CharSequence)"1.")) {
            Matcher m = JAVA_VERSION_1_X.matcher(version);
            m.find();
            return m.group();
        }
        Matcher m = JAVA_VERSION_X.matcher(version);
        m.find();
        return m.group();
    }

    public static boolean is9OrLater(String targetVersion) {
        if (StringUtils.isNotBlank((CharSequence)targetVersion)) {
            Double v = Double.valueOf(targetVersion);
            return v >= 9.0 || v < 2.0 && v >= 1.9;
        }
        return false;
    }
}

