/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.maven;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jsonschema2pojo.AllFileFilter;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.maven.MatchPatternsFileFilter;
import org.jsonschema2pojo.maven.ProjectClasspath;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2PojoMojo
extends AbstractMojo
implements GenerationConfig {
    private File outputDirectory;
    private String sourceDirectory;
    private String[] sourcePaths;
    private String targetPackage = "";
    private boolean generateBuilders = false;
    private boolean usePrimitives = false;
    private boolean addCompileSourceRoot = true;
    private boolean skip = false;
    private String propertyWordDelimiters = "- _";
    private boolean useLongIntegers = false;
    private boolean useBigIntegers = false;
    private boolean useDoubleNumbers = true;
    private boolean useBigDecimals = false;
    private boolean includeHashcodeAndEquals = true;
    private boolean includeToString = true;
    private String annotationStyle = "jackson2";
    private String customAnnotator = NoopAnnotator.class.getName();
    private String customRuleFactory = RuleFactory.class.getName();
    private boolean includeJsr303Annotations = false;
    private String sourceType = "jsonschema";
    private boolean removeOldOutput = false;
    private String outputEncoding = "UTF-8";
    private boolean useJodaDates = false;
    private boolean useJodaLocalDates = false;
    private boolean useJodaLocalTimes = false;
    private String dateTimeType = null;
    private String timeType = null;
    private String dateType = null;
    private boolean useCommonsLang3 = false;
    private boolean parcelable = false;
    private boolean serializable = false;
    private boolean initializeCollections = true;
    private String[] includes;
    private String[] excludes;
    private String classNamePrefix = "";
    private String classNameSuffix = "";
    private String[] fileExtensions = new String[0];
    private boolean includeConstructors = false;
    private boolean constructorsRequiredPropertiesOnly = false;
    private boolean includeAdditionalProperties = true;
    private boolean includeAccessors = true;
    private String targetVersion = "1.6";
    private boolean includeDynamicAccessors = false;
    private MavenProject project;
    private FileFilter fileFilter = new AllFileFilter();

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Private fields set by Maven.")
    public void execute() throws MojoExecutionException {
        this.addProjectDependenciesToClasspath();
        try {
            this.getAnnotationStyle();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Not a valid annotation style: " + this.annotationStyle);
        }
        try {
            new AnnotatorFactory().getAnnotator(this.getCustomAnnotator());
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.skip) {
            return;
        }
        if (this.sourceDirectory != null) {
            try {
                URLUtil.parseURL((String)this.sourceDirectory);
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else if (!ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
            for (String source : this.sourcePaths) {
                try {
                    URLUtil.parseURL((String)source);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        } else {
            throw new MojoExecutionException("One of sourceDirectory or sourcePaths must be provided");
        }
        if (this.filteringEnabled() || this.sourceDirectory != null && ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
            if (this.sourceDirectory == null) {
                throw new MojoExecutionException("Source includes and excludes require the sourceDirectory property");
            }
            if (!ArrayUtils.isEmpty((Object[])this.sourcePaths)) {
                throw new MojoExecutionException("Source includes and excludes are incompatible with the sourcePaths property");
            }
            this.fileFilter = this.createFileFilter();
        }
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        }
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating classes from JSON Schema file(s) " + this.sourceDirectory, (Exception)e);
        }
    }

    private void addProjectDependenciesToClasspath() {
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = new ProjectClasspath().getClassLoader(this.project, oldClassLoader, this.getLog());
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().info((CharSequence)"Skipping addition of project artifacts, there appears to be a dependecy resolution problem", (Throwable)e);
        }
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public File getTargetDirectory() {
        return this.outputDirectory;
    }

    public Iterator<URL> getSource() {
        if (null != this.sourceDirectory) {
            return Collections.singleton(URLUtil.parseURL((String)this.sourceDirectory)).iterator();
        }
        ArrayList<URL> sourceURLs = new ArrayList<URL>();
        for (String source : this.sourcePaths) {
            sourceURLs.add(URLUtil.parseURL((String)source));
        }
        return sourceURLs.iterator();
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return this.propertyWordDelimiters.toCharArray();
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return this.useDoubleNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public AnnotationStyle getAnnotationStyle() {
        return AnnotationStyle.valueOf((String)this.annotationStyle.toUpperCase());
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        if (StringUtils.isNotBlank((CharSequence)this.customAnnotator)) {
            try {
                return Class.forName(this.customAnnotator);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return NoopAnnotator.class;
    }

    public Class<? extends RuleFactory> getCustomRuleFactory() {
        if (StringUtils.isNotBlank((CharSequence)this.customRuleFactory)) {
            try {
                return Class.forName(this.customRuleFactory);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return RuleFactory.class;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public SourceType getSourceType() {
        return SourceType.valueOf((String)this.sourceType.toUpperCase());
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }

    public boolean isUseJodaLocalDates() {
        return this.useJodaLocalDates;
    }

    public boolean isUseJodaLocalTimes() {
        return this.useJodaLocalTimes;
    }

    public boolean isUseCommonsLang3() {
        return this.useCommonsLang3;
    }

    public boolean isParcelable() {
        return this.parcelable;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public boolean isInitializeCollections() {
        return this.initializeCollections;
    }

    boolean filteringEnabled() {
        return this.includes != null && this.includes.length != 0 || this.excludes != null && this.excludes.length != 0;
    }

    FileFilter createFileFilter() throws MojoExecutionException {
        try {
            URL urlSource = URLUtil.parseURL((String)this.sourceDirectory);
            return new MatchPatternsFileFilter.Builder().addIncludes(this.includes).addExcludes(this.excludes).addDefaultExcludes().withSourceDirectory(URLUtil.getFileFromURL((URL)urlSource).getCanonicalPath()).withCaseSensitive(false).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not create file filter", (Exception)e);
        }
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public String getClassNameSuffix() {
        return this.classNameSuffix;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isIncludeConstructors() {
        return this.includeConstructors;
    }

    public boolean isConstructorsRequiredPropertiesOnly() {
        return this.constructorsRequiredPropertiesOnly;
    }

    public boolean isIncludeAdditionalProperties() {
        return this.includeAdditionalProperties;
    }

    public boolean isIncludeAccessors() {
        return this.includeAccessors;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isIncludeDynamicAccessors() {
        return this.includeDynamicAccessors;
    }

    public String getDateTimeType() {
        return this.dateTimeType;
    }

    public String getDateType() {
        return this.dateType;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public boolean isUseBigIntegers() {
        return this.useBigIntegers;
    }

    public boolean isUseBigDecimals() {
        return this.useBigDecimals;
    }
}

