/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.model.tree;

import java.util.ArrayList;
import java.util.List;
import org.jtwig.model.expression.VariableExpression;
import org.jtwig.model.position.Position;
import org.jtwig.model.tree.ContentNode;
import org.jtwig.model.tree.Node;

public class MacroNode
extends ContentNode {
    private final VariableExpression macroName;
    private final List<String> macroArgumentNames;

    public static MacroNode create(Position position, VariableExpression macroName, List<VariableExpression> macroArgumentExpressions, Node content) {
        ArrayList<String> macroArgumentNames = new ArrayList<String>();
        for (VariableExpression variableExpression : macroArgumentExpressions) {
            macroArgumentNames.add(variableExpression.getIdentifier());
        }
        return new MacroNode(position, macroName, macroArgumentNames, content);
    }

    public MacroNode(Position position, VariableExpression macroName, List<String> macroArgumentNames, Node content) {
        super(position, content);
        this.macroName = macroName;
        this.macroArgumentNames = macroArgumentNames;
    }

    public VariableExpression getMacroName() {
        return this.macroName;
    }

    public List<String> getMacroArgumentNames() {
        return this.macroArgumentNames;
    }
}

