/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.config;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.jtwig.parser.addon.AddonParserProvider;
import org.jtwig.parser.cache.TemplateCache;
import org.jtwig.parser.config.AndSyntaxConfigurationBuilder;
import org.jtwig.parser.config.JtwigParserConfiguration;
import org.jtwig.parser.parboiled.expression.test.TestExpressionParser;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.jtwig.render.expression.calculator.operation.unary.UnaryOperator;
import org.jtwig.util.builder.ListBuilder;
import org.jtwig.util.builder.MapBuilder;

public class JtwigParserConfigurationBuilder<B extends JtwigParserConfigurationBuilder>
implements Builder<JtwigParserConfiguration> {
    private AndSyntaxConfigurationBuilder<B> syntaxConfiguration;
    private final ListBuilder<B, AddonParserProvider> addonParserProviders;
    private final ListBuilder<B, UnaryOperator> unaryOperators;
    private final ListBuilder<B, BinaryOperator> binaryOperators;
    private final ListBuilder<B, Class<? extends TestExpressionParser>> testExpressionParsers;
    private Optional<TemplateCache> templateCache;
    private final MapBuilder<B, String, Object> properties;

    public JtwigParserConfigurationBuilder() {
        this.syntaxConfiguration = new AndSyntaxConfigurationBuilder<B>(this.self());
        this.addonParserProviders = new ListBuilder(this.self());
        this.unaryOperators = new ListBuilder(this.self());
        this.binaryOperators = new ListBuilder(this.self());
        this.testExpressionParsers = new ListBuilder(this.self());
        this.properties = new MapBuilder(this.self());
    }

    public JtwigParserConfigurationBuilder(JtwigParserConfiguration prototype) {
        this.syntaxConfiguration = new AndSyntaxConfigurationBuilder<B>(this.self(), prototype.getSyntaxConfiguration());
        this.addonParserProviders = new ListBuilder<B, AddonParserProvider>(this.self(), prototype.getAddonParserProviders());
        this.unaryOperators = new ListBuilder<B, UnaryOperator>(this.self(), prototype.getUnaryOperators());
        this.binaryOperators = new ListBuilder<B, BinaryOperator>(this.self(), prototype.getBinaryOperators());
        this.testExpressionParsers = new ListBuilder<B, Class<TestExpressionParser>>(this.self(), prototype.getTestExpressionParsers());
        this.templateCache = prototype.getTemplateCache();
        this.properties = new MapBuilder<B, String, Object>(this.self(), prototype.getProperties());
    }

    public AndSyntaxConfigurationBuilder<B> syntax() {
        return this.syntaxConfiguration;
    }

    public B withTemplateCache(TemplateCache templateCache) {
        this.templateCache = Optional.fromNullable((Object)templateCache);
        return this.self();
    }

    public B withoutTemplateCache() {
        this.templateCache = Optional.absent();
        return this.self();
    }

    public ListBuilder<B, AddonParserProvider> addonParserProviders() {
        return this.addonParserProviders;
    }

    public ListBuilder<B, UnaryOperator> unaryOperators() {
        return this.unaryOperators;
    }

    public ListBuilder<B, BinaryOperator> binaryOperators() {
        return this.binaryOperators;
    }

    public ListBuilder<B, Class<? extends TestExpressionParser>> testExpressionParsers() {
        return this.testExpressionParsers;
    }

    public MapBuilder<B, String, Object> properties() {
        return this.properties;
    }

    protected B self() {
        return (B)this;
    }

    public JtwigParserConfiguration build() {
        return new JtwigParserConfiguration(this.syntaxConfiguration.build(), (List<AddonParserProvider>)this.addonParserProviders.build(), (Collection<UnaryOperator>)this.unaryOperators.build(), (Collection<BinaryOperator>)this.binaryOperators.build(), (List<Class<? extends TestExpressionParser>>)this.testExpressionParsers.build(), this.templateCache, (Map<String, Object>)this.properties.build());
    }
}

