/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.selection;

import com.google.common.base.Optional;
import org.jtwig.property.resolver.PropertyResolver;
import org.jtwig.property.selection.SelectionPropertyResolveService;
import org.jtwig.property.selection.SelectionPropertyResolver;
import org.jtwig.property.selection.SelectionRequest;
import org.jtwig.property.selection.SelectionResult;
import org.jtwig.property.selection.cache.SelectionPropertyResolverCache;
import org.jtwig.property.selection.cache.SelectionPropertyResolverCacheKey;

public class CachedSelectionPropertyResolver
implements SelectionPropertyResolver {
    private final SelectionPropertyResolverCache selectionPropertyResolverCache;
    private final SelectionPropertyResolver delegate;
    private final SelectionPropertyResolveService selectionPropertyResolveService;

    public CachedSelectionPropertyResolver(SelectionPropertyResolverCache selectionPropertyResolverCache, SelectionPropertyResolver delegate, SelectionPropertyResolveService selectionPropertyResolveService) {
        this.selectionPropertyResolverCache = selectionPropertyResolverCache;
        this.delegate = delegate;
        this.selectionPropertyResolveService = selectionPropertyResolveService;
    }

    @Override
    public SelectionResult resolve(SelectionRequest request) {
        Object leftValue = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService().calculate(request, request.getLeftExpression());
        SelectionPropertyResolverCacheKey cacheKey = SelectionPropertyResolverCacheKey.createFor(leftValue, request.getRightExpression());
        Optional<PropertyResolver> result = this.selectionPropertyResolverCache.getCachedResolver(cacheKey);
        if (result.isPresent()) {
            PropertyResolver propertyResolver = (PropertyResolver)result.get();
            return this.selectionPropertyResolveService.resolve(propertyResolver, request, leftValue);
        }
        SelectionResult cacheMissResult = this.delegate.resolve(request);
        if (cacheMissResult.getPropertyResolver().isPresent()) {
            this.selectionPropertyResolverCache.cacheResolver(cacheKey, (PropertyResolver)cacheMissResult.getPropertyResolver().get());
        }
        return cacheMissResult;
    }
}

