/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jtwig.reflection.model.java.JavaMethodArgument;

public class JavaMethod {
    private final Method method;
    private List<JavaMethodArgument> arguments;

    public JavaMethod(Method method) {
        this.method = method;
        this.method.setAccessible(true);
    }

    public List<JavaMethodArgument> arguments() {
        if (this.arguments == null) {
            ArrayList<JavaMethodArgument> result = new ArrayList<JavaMethodArgument>();
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result.add(new JavaMethodArgument(this, i));
            }
            this.arguments = result;
        }
        return this.arguments;
    }

    public Object invoke(Object bean, Object[] arguments) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(bean, arguments);
    }

    public Class type(int position) {
        return this.method.getParameterTypes()[position];
    }

    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public int numberOfArguments() {
        return this.method.getParameterTypes().length;
    }

    public <T extends Annotation> Optional<T> argumentAnnotation(int position, Class<T> type) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.method.getParameterAnnotations()[position]) {
            if (!annotation.annotationType().equals(type)) continue;
            return Optional.of(type.cast(annotation));
        }
        return Optional.absent();
    }

    public <T extends Annotation> Optional<T> annotation(Class<T> type) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.method.getAnnotations()) {
            if (!annotation.annotationType().equals(type)) continue;
            return Optional.of(type.cast(annotation));
        }
        return Optional.absent();
    }

    public String name() {
        return this.method.getName();
    }

    public Method getNative() {
        return this.method;
    }
}

