/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.resolver.argument;

import com.google.common.base.Optional;
import org.jtwig.reflection.input.InputParameterResolverContext;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethodArgument;
import org.jtwig.reflection.resolver.argument.ArgumentResolver;
import org.jtwig.reflection.resolver.argument.InputArgumentValueResolver;

public class InputArgumentResolver<InputParameterType>
implements ArgumentResolver {
    private final InputArgumentValueResolver<InputParameterType> resolver;
    private final InputParameterResolverContext<InputParameterType> context;

    public InputArgumentResolver(InputArgumentValueResolver<InputParameterType> resolver, InputParameterResolverContext<InputParameterType> context) {
        this.resolver = resolver;
        this.context = context;
    }

    @Override
    public Optional<Value> resolve(JavaMethodArgument methodArgument) {
        Object clonedContext = this.context.clone();
        Optional<Value> result = this.resolver.resolve(methodArgument, (InputParameterResolverContext<InputParameterType>)clonedContext);
        if (result.isPresent()) {
            this.context.merge((InputParameterResolverContext<InputParameterType>)clonedContext);
        }
        return result;
    }

    public boolean isFullyResolved() {
        return this.context.fullyUsed();
    }
}

