/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.DetailsPrintingListener;
import org.junit.platform.console.tasks.Style;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class FlatPrintingListener
implements DetailsPrintingListener {
    static final String INDENTATION = "             ";
    private final PrintWriter out;
    private final ColorPalette colorPalette;

    FlatPrintingListener(PrintWriter out, ColorPalette colorPalette) {
        this.out = out;
        this.colorPalette = colorPalette;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.out.printf("Test execution started. Number of static tests: %d%n", testPlan.countTestIdentifiers(TestIdentifier::isTest));
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.out.println("Test execution finished.");
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Style.DYNAMIC, "Registered:", testIdentifier);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printlnTestDescriptor(Style.SKIPPED, "Skipped:", testIdentifier);
        this.printlnMessage(Style.SKIPPED, "Reason", reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Style.valueOf(testIdentifier), "Started:", testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Style style = Style.valueOf(testExecutionResult);
        this.printlnTestDescriptor(style, "Finished:", testIdentifier);
        testExecutionResult.getThrowable().ifPresent(t -> this.printlnException(style, (Throwable)t));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printlnTestDescriptor(Style.REPORTED, "Reported:", testIdentifier);
        this.printlnMessage(Style.REPORTED, "Reported values", entry.toString());
    }

    private void printlnTestDescriptor(Style style, String message, TestIdentifier testIdentifier) {
        this.println(style, "%-10s   %s (%s)", message, testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    private void printlnException(Style style, Throwable throwable) {
        this.printlnMessage(style, "Exception", ExceptionUtils.readStackTrace((Throwable)throwable));
    }

    private void printlnMessage(Style style, String message, String detail) {
        this.println(style, "             => " + message + ": %s", FlatPrintingListener.indented(detail));
    }

    private void println(Style style, String format, Object ... args) {
        this.out.println(this.colorPalette.paint(style, String.format(format, args)));
    }

    private static String indented(String message) {
        return DetailsPrintingListener.indented(message, INDENTATION);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        testPlan.accept(new TestPlan.Visitor(){

            public void visit(TestIdentifier testIdentifier) {
                FlatPrintingListener.this.println(Style.valueOf(testIdentifier), "%s (%s)", new Object[]{testIdentifier.getDisplayName(), testIdentifier.getUniqueId()});
            }
        });
    }
}

