/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.PrintWriter;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.console.options.CommandResult;
import org.junit.platform.console.options.MainCommand;
import org.junit.platform.console.options.ManifestVersionProvider;
import org.junit.platform.console.options.OutputStreamConfig;
import org.junit.platform.console.tasks.ConsoleTestExecutor;

@API(status=API.Status.INTERNAL, since="1.10")
public class CommandFacade {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;

    public CommandFacade(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    public CommandResult<?> run(String[] args) {
        return this.run(args, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult<?> run(String[] args, PrintWriter out, PrintWriter err) {
        try {
            CommandResult<?> commandResult = this.run(args, Optional.of(new OutputStreamConfig(out, err)));
            return commandResult;
        }
        finally {
            out.flush();
            err.flush();
        }
    }

    private CommandResult<?> run(String[] args, Optional<OutputStreamConfig> outputStreamConfig) {
        Optional<String> version = ManifestVersionProvider.getImplementationVersion();
        System.setProperty("junit.docs.version", version.map(it -> it.endsWith("-SNAPSHOT") ? "snapshot" : it).orElse("current"));
        return new MainCommand(this.consoleTestExecutorFactory).run(args, outputStreamConfig);
    }
}

