/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.INTERNAL, since="1.10")
public class TestDiscoveryOptions {
    private boolean scanClasspath;
    private List<Path> additionalClasspathEntries = Collections.emptyList();
    private List<Path> selectedClasspathEntries = Collections.emptyList();
    private boolean scanModulepath;
    private List<ModuleSelector> selectedModules = Collections.emptyList();
    private List<UriSelector> selectedUris = Collections.emptyList();
    private List<FileSelector> selectedFiles = Collections.emptyList();
    private List<DirectorySelector> selectedDirectories = Collections.emptyList();
    private List<PackageSelector> selectedPackages = Collections.emptyList();
    private List<ClassSelector> selectedClasses = Collections.emptyList();
    private List<MethodSelector> selectedMethods = Collections.emptyList();
    private List<ClasspathResourceSelector> selectedClasspathResources = Collections.emptyList();
    private List<IterationSelector> selectedIterations = Collections.emptyList();
    private List<UniqueIdSelector> selectedUniqueIds = Collections.emptyList();
    private List<DiscoverySelectorIdentifier> selectorIdentifiers = Collections.emptyList();
    private List<String> includedClassNamePatterns = Collections.singletonList("^(Test.*|.+[.$]Test.*|.*Tests?)$");
    private List<String> excludedClassNamePatterns = Collections.emptyList();
    private List<String> includedPackages = Collections.emptyList();
    private List<String> excludedPackages = Collections.emptyList();
    private List<String> includedMethodNamePatterns = Collections.emptyList();
    private List<String> excludedMethodNamePatterns = Collections.emptyList();
    private List<String> includedEngines = Collections.emptyList();
    private List<String> excludedEngines = Collections.emptyList();
    private List<String> includedTagExpressions = Collections.emptyList();
    private List<String> excludedTagExpressions = Collections.emptyList();
    private List<String> configurationParametersResources = Collections.emptyList();
    private Map<String, String> configurationParameters = Collections.emptyMap();

    public boolean isScanModulepath() {
        return this.scanModulepath;
    }

    public void setScanModulepath(boolean scanModulepath) {
        this.scanModulepath = scanModulepath;
    }

    public boolean isScanClasspath() {
        return this.scanClasspath;
    }

    public void setScanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
    }

    public List<Path> getExistingAdditionalClasspathEntries() {
        return this.additionalClasspathEntries.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    public List<Path> getAdditionalClasspathEntries() {
        return this.additionalClasspathEntries;
    }

    public void setAdditionalClasspathEntries(List<Path> additionalClasspathEntries) {
        this.additionalClasspathEntries = additionalClasspathEntries;
    }

    public List<Path> getSelectedClasspathEntries() {
        return this.selectedClasspathEntries;
    }

    public void setSelectedClasspathEntries(List<Path> selectedClasspathEntries) {
        this.selectedClasspathEntries = selectedClasspathEntries;
    }

    public List<UriSelector> getSelectedUris() {
        return this.selectedUris;
    }

    public void setSelectedUris(List<UriSelector> selectedUris) {
        this.selectedUris = selectedUris;
    }

    public List<FileSelector> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFiles(List<FileSelector> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public List<DirectorySelector> getSelectedDirectories() {
        return this.selectedDirectories;
    }

    public void setSelectedDirectories(List<DirectorySelector> selectedDirectories) {
        this.selectedDirectories = selectedDirectories;
    }

    public List<ModuleSelector> getSelectedModules() {
        return this.selectedModules;
    }

    public void setSelectedModules(List<ModuleSelector> selectedModules) {
        this.selectedModules = selectedModules;
    }

    public List<PackageSelector> getSelectedPackages() {
        return this.selectedPackages;
    }

    public void setSelectedPackages(List<PackageSelector> selectedPackages) {
        this.selectedPackages = selectedPackages;
    }

    public List<ClassSelector> getSelectedClasses() {
        return this.selectedClasses;
    }

    public void setSelectedClasses(List<ClassSelector> selectedClasses) {
        this.selectedClasses = selectedClasses;
    }

    public List<MethodSelector> getSelectedMethods() {
        return this.selectedMethods;
    }

    public void setSelectedMethods(List<MethodSelector> selectedMethods) {
        this.selectedMethods = selectedMethods;
    }

    public List<ClasspathResourceSelector> getSelectedClasspathResources() {
        return this.selectedClasspathResources;
    }

    public void setSelectedClasspathResources(List<ClasspathResourceSelector> selectedClasspathResources) {
        this.selectedClasspathResources = selectedClasspathResources;
    }

    public List<IterationSelector> getSelectedIterations() {
        return this.selectedIterations;
    }

    public void setSelectedIterations(List<IterationSelector> selectedIterations) {
        this.selectedIterations = selectedIterations;
    }

    public List<UniqueIdSelector> getSelectedUniqueIds() {
        return this.selectedUniqueIds;
    }

    public void setSelectedUniqueId(List<UniqueIdSelector> selectedUniqueIds) {
        this.selectedUniqueIds = selectedUniqueIds;
    }

    public List<DiscoverySelectorIdentifier> getSelectorIdentifiers() {
        return this.selectorIdentifiers;
    }

    public void setSelectorIdentifiers(List<DiscoverySelectorIdentifier> selectorIdentifiers) {
        this.selectorIdentifiers = selectorIdentifiers;
    }

    public List<DiscoverySelector> getExplicitSelectors() {
        ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        selectors.addAll(this.getSelectedUris());
        selectors.addAll(this.getSelectedFiles());
        selectors.addAll(this.getSelectedDirectories());
        selectors.addAll(this.getSelectedModules());
        selectors.addAll(this.getSelectedPackages());
        selectors.addAll(this.getSelectedClasses());
        selectors.addAll(this.getSelectedMethods());
        selectors.addAll(this.getSelectedClasspathResources());
        selectors.addAll(this.getSelectedIterations());
        DiscoverySelectors.parseAll(this.getSelectorIdentifiers()).forEach(selectors::add);
        return selectors;
    }

    public List<String> getIncludedClassNamePatterns() {
        return this.includedClassNamePatterns;
    }

    public void setIncludedClassNamePatterns(List<String> includedClassNamePatterns) {
        this.includedClassNamePatterns = includedClassNamePatterns;
    }

    public List<String> getExcludedClassNamePatterns() {
        return this.excludedClassNamePatterns;
    }

    public void setExcludedClassNamePatterns(List<String> excludedClassNamePatterns) {
        this.excludedClassNamePatterns = excludedClassNamePatterns;
    }

    public List<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public List<String> getIncludedMethodNamePatterns() {
        return this.includedMethodNamePatterns;
    }

    public void setIncludedMethodNamePatterns(List<String> includedMethodNamePatterns) {
        this.includedMethodNamePatterns = includedMethodNamePatterns;
    }

    public List<String> getExcludedMethodNamePatterns() {
        return this.excludedMethodNamePatterns;
    }

    public void setExcludedMethodNamePatterns(List<String> excludedMethodNamePatterns) {
        this.excludedMethodNamePatterns = excludedMethodNamePatterns;
    }

    public List<String> getIncludedEngines() {
        return this.includedEngines;
    }

    public void setIncludedEngines(List<String> includedEngines) {
        this.includedEngines = includedEngines;
    }

    public List<String> getExcludedEngines() {
        return this.excludedEngines;
    }

    public void setExcludedEngines(List<String> excludedEngines) {
        this.excludedEngines = excludedEngines;
    }

    public List<String> getIncludedTagExpressions() {
        return this.includedTagExpressions;
    }

    public void setIncludedTagExpressions(List<String> includedTags) {
        this.includedTagExpressions = includedTags;
    }

    public List<String> getExcludedTagExpressions() {
        return this.excludedTagExpressions;
    }

    public void setExcludedTagExpressions(List<String> excludedTags) {
        this.excludedTagExpressions = excludedTags;
    }

    public Map<String, String> getConfigurationParameters() {
        return this.configurationParameters;
    }

    public void setConfigurationParameters(Map<String, String> configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public List<String> getConfigurationParametersResources() {
        return this.configurationParametersResources;
    }

    public TestDiscoveryOptions setConfigurationParametersResources(List<String> configurationParametersResources) {
        this.configurationParametersResources = configurationParametersResources;
        return this;
    }
}

