/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.jfr;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import org.apiguardian.api.API;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.jfr.UniqueId;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

@API(status=API.Status.STABLE, since="1.11")
public class FlightRecordingDiscoveryListener
implements LauncherDiscoveryListener {
    private final AtomicReference<LauncherDiscoveryEvent> launcherDiscoveryEvent = new AtomicReference();
    private final Map<org.junit.platform.engine.UniqueId, EngineDiscoveryEvent> engineDiscoveryEvents = new ConcurrentHashMap<org.junit.platform.engine.UniqueId, EngineDiscoveryEvent>();

    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        LauncherDiscoveryEvent event = new LauncherDiscoveryEvent();
        event.selectors = request.getSelectorsByType(DiscoverySelector.class).size();
        event.filters = request.getFiltersByType(DiscoveryFilter.class).size();
        event.begin();
        this.launcherDiscoveryEvent.set(event);
    }

    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        ((LauncherDiscoveryEvent)this.launcherDiscoveryEvent.getAndSet(null)).commit();
    }

    public void engineDiscoveryStarted(org.junit.platform.engine.UniqueId engineId) {
        EngineDiscoveryEvent event = new EngineDiscoveryEvent();
        event.uniqueId = engineId.toString();
        event.begin();
        this.engineDiscoveryEvents.put(engineId, event);
    }

    public void engineDiscoveryFinished(org.junit.platform.engine.UniqueId engineId, EngineDiscoveryResult result) {
        EngineDiscoveryEvent event = this.engineDiscoveryEvents.remove(engineId);
        event.result = result.getStatus().toString();
        event.commit();
    }

    @Label(value="Engine Discovery")
    @Category(value={"JUnit", "Discovery"})
    @Name(value="org.junit.EngineDiscovery")
    static class EngineDiscoveryEvent
    extends DiscoveryEvent {
        @UniqueId
        @Label(value="Unique Id")
        String uniqueId;
        @Label(value="Result")
        String result;

        EngineDiscoveryEvent() {
        }
    }

    @Label(value="Test Discovery")
    @Category(value={"JUnit", "Discovery"})
    @Name(value="org.junit.LauncherDiscovery")
    static class LauncherDiscoveryEvent
    extends DiscoveryEvent {
        @Label(value="Number of selectors")
        int selectors;
        @Label(value="Number of filters")
        int filters;

        LauncherDiscoveryEvent() {
        }
    }

    @Category(value={"JUnit", "Discovery"})
    @StackTrace(value=false)
    static abstract class DiscoveryEvent
    extends Event {
        DiscoveryEvent() {
        }
    }
}

