/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.api.ConfigurationParameter;
import org.junit.platform.suite.api.DisableParentConfigurationParameters;
import org.junit.platform.suite.api.ExcludeClassNamePatterns;
import org.junit.platform.suite.api.ExcludeEngines;
import org.junit.platform.suite.api.ExcludePackages;
import org.junit.platform.suite.api.ExcludeTags;
import org.junit.platform.suite.api.IncludeClassNamePatterns;
import org.junit.platform.suite.api.IncludeEngines;
import org.junit.platform.suite.api.IncludePackages;
import org.junit.platform.suite.api.IncludeTags;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.SelectClasspathResource;
import org.junit.platform.suite.api.SelectDirectories;
import org.junit.platform.suite.api.SelectFile;
import org.junit.platform.suite.api.SelectModules;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.SelectUris;
import org.junit.platform.suite.commons.AdditionalDiscoverySelectors;

@API(status=API.Status.INTERNAL, since="1.8", consumers={"org.junit.platform.suite.engine", "org.junit.platform.runner"})
public final class SuiteLauncherDiscoveryRequestBuilder {
    private final LauncherDiscoveryRequestBuilder delegate = LauncherDiscoveryRequestBuilder.request();
    private final List<String> selectedClassNames = new ArrayList<String>();
    private boolean includeClassNamePatternsUsed;
    private boolean filterStandardClassNamePatterns = false;
    private ConfigurationParameters parentConfigurationParameters;
    private boolean enableParentConfigurationParameters = true;

    private SuiteLauncherDiscoveryRequestBuilder() {
    }

    public static SuiteLauncherDiscoveryRequestBuilder request() {
        return new SuiteLauncherDiscoveryRequestBuilder();
    }

    public SuiteLauncherDiscoveryRequestBuilder filterStandardClassNamePatterns(boolean filterStandardClassNamePatterns) {
        this.filterStandardClassNamePatterns = filterStandardClassNamePatterns;
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder selectors(DiscoverySelector ... selectors) {
        this.delegate.selectors(selectors);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder selectors(List<? extends DiscoverySelector> selectors) {
        this.delegate.selectors(selectors);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder filters(Filter<?> ... filters) {
        this.delegate.filters(filters);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder configurationParameter(String key, String value) {
        this.delegate.configurationParameter(key, value);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder configurationParameters(Map<String, String> configurationParameters) {
        this.delegate.configurationParameters(configurationParameters);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder parentConfigurationParameters(ConfigurationParameters parentConfigurationParameters) {
        this.parentConfigurationParameters = parentConfigurationParameters;
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder enableImplicitConfigurationParameters(boolean enabled) {
        this.delegate.enableImplicitConfigurationParameters(enabled);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder suite(Class<?> suiteClass) {
        Preconditions.notNull(suiteClass, (String)"Suite class must not be null");
        AnnotationUtils.findRepeatableAnnotations(suiteClass, ConfigurationParameter.class).forEach(configuration -> this.configurationParameter(configuration.key(), configuration.value()));
        AnnotationUtils.findAnnotation(suiteClass, DisableParentConfigurationParameters.class).ifPresent(__ -> {
            this.enableParentConfigurationParameters = false;
        });
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeClassNamePatterns.class, ExcludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(ClassNameFilter::excludeClassNamePatterns).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeEngines.class, ExcludeEngines::value).map(EngineFilter::excludeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludePackages.class, ExcludePackages::value).map(PackageNameFilter::excludePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeTags.class, ExcludeTags::value).map(TagFilter::excludeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectClasses.class, SelectClasses::value).map(this::selectClasses).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeClassNamePatterns.class, IncludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(this::createIncludeClassNameFilter).ifPresent(filters -> {
            this.includeClassNamePatternsUsed = true;
            this.filters(new Filter[]{filters});
        });
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeEngines.class, IncludeEngines::value).map(EngineFilter::includeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludePackages.class, IncludePackages::value).map(PackageNameFilter::includePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeTags.class, IncludeTags::value).map(TagFilter::includeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        AnnotationUtils.findRepeatableAnnotations(suiteClass, SelectClasspathResource.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectClasspathResource(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectDirectories.class, SelectDirectories::value).map(AdditionalDiscoverySelectors::selectDirectories).ifPresent(this::selectors);
        AnnotationUtils.findRepeatableAnnotations(suiteClass, SelectFile.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectFile(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectModules.class, SelectModules::value).map(AdditionalDiscoverySelectors::selectModules).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectUris.class, SelectUris::value).map(AdditionalDiscoverySelectors::selectUris).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectPackages.class, SelectPackages::value).map(AdditionalDiscoverySelectors::selectPackages).ifPresent(this::selectors);
        return this;
    }

    public LauncherDiscoveryRequest build() {
        if (this.filterStandardClassNamePatterns && !this.includeClassNamePatternsUsed) {
            this.delegate.filters(new Filter[]{this.createIncludeClassNameFilter("^(Test.*|.+[.$]Test.*|.*Tests?)$")});
        }
        if (this.enableParentConfigurationParameters && this.parentConfigurationParameters != null) {
            this.delegate.parentConfigurationParameters(this.parentConfigurationParameters);
        }
        return this.delegate.build();
    }

    private List<ClassSelector> selectClasses(Class<?> ... classes) {
        Arrays.stream(classes).map(Class::getName).distinct().forEach(this.selectedClassNames::add);
        return AdditionalDiscoverySelectors.selectClasses(classes);
    }

    private ClassNameFilter createIncludeClassNameFilter(String ... patterns) {
        String[] combinedPatterns = (String[])Stream.concat(this.selectedClassNames.stream().map(Pattern::quote), Arrays.stream(patterns)).toArray(String[]::new);
        return ClassNameFilter.includeClassNamePatterns((String[])combinedPatterns);
    }

    private static <A extends Annotation, V> Optional<V[]> findAnnotationValues(AnnotatedElement element, Class<A> annotationType, Function<A, V[]> valueExtractor) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, annotationType).map(valueExtractor).filter(values -> ((Object[])values).length > 0);
    }

    private static Optional<String[]> trimmed(String[] patterns) {
        if (patterns.length == 0) {
            return Optional.empty();
        }
        return Optional.of((String[])Arrays.stream(patterns).filter(StringUtils::isNotBlank).map(String::trim).toArray(String[]::new));
    }
}

