/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.logging.Logger;

public enum Protocol {
    ALL("*"),
    HTTP_GET("http-get"),
    RTSP_RTP_UDP("rtsp-rtp-udp"),
    INTERNAL("internal"),
    IEC61883("iec61883"),
    XBMC_GET("xbmc-get"),
    OTHER("other");

    private static final Logger logger;
    private String protocolString;

    static {
        logger = Logger.getLogger(Protocol.class.getName());
    }

    private Protocol(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static Protocol value(String s) {
        Protocol[] protocolArray = Protocol.values();
        int n = protocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol protocol = protocolArray[n2];
            if (protocol.toString().equals(s)) {
                return protocol;
            }
            ++n2;
        }
        logger.info("Unsupported OTHER protocol string: " + s);
        return OTHER;
    }
}

