/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;

public class DLNAHeaders
extends UpnpHeaders {
    private final Logger logger = Logger.getLogger(DLNAHeaders.class.getName());
    protected Map<DLNAHeader.Type, List<UpnpHeader<?>>> parsedDLNAHeaders;

    public DLNAHeaders() {
    }

    public DLNAHeaders(Map<String, List<String>> headers) {
        super(headers);
    }

    public DLNAHeaders(ByteArrayInputStream inputStream) {
        super(inputStream);
    }

    protected void parseHeaders() {
        if (this.parsedHeaders == null) {
            super.parseHeaders();
        }
        this.parsedDLNAHeaders = new LinkedHashMap();
        this.logger.log(Level.FINE, "Parsing all HTTP headers for known UPnP headers: {0}", this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getKey() == null) continue;
            DLNAHeader.Type type = DLNAHeader.Type.getByHttpName((String)entry.getKey());
            if (type == null) {
                this.logger.log(Level.FINE, "Ignoring non-UPNP HTTP header: {0}", entry.getKey());
                continue;
            }
            for (String value : (List)entry.getValue()) {
                DLNAHeader<?> upnpHeader = DLNAHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    this.logger.log(Level.FINE, "Ignoring known but non-parsable header (value violates the UDA specification?) '{0}': {1}", new Object[]{type.getHttpName(), value});
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    protected void addParsedValue(DLNAHeader.Type type, UpnpHeader<?> value) {
        this.logger.log(Level.FINE, "Adding parsed header: {0}", value);
        List<UpnpHeader<?>> list = this.parsedDLNAHeaders.get((Object)type);
        if (list == null) {
            list = new LinkedList();
            this.parsedDLNAHeaders.put(type, list);
        }
        list.add(value);
    }

    public List<String> put(String key, List<String> values) {
        this.parsedDLNAHeaders = null;
        return super.put(key, values);
    }

    public void add(String key, String value) {
        this.parsedDLNAHeaders = null;
        super.add(key, value);
    }

    public List<String> remove(Object key) {
        this.parsedDLNAHeaders = null;
        return super.remove(key);
    }

    public void clear() {
        this.parsedDLNAHeaders = null;
        super.clear();
    }

    public boolean containsKey(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.containsKey((Object)type);
    }

    public List<UpnpHeader<?>> get(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.get((Object)type);
    }

    public void add(DLNAHeader.Type type, UpnpHeader<?> value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedDLNAHeaders != null) {
            this.addParsedValue(type, value);
        }
    }

    public void remove(DLNAHeader.Type type) {
        super.remove((Object)type.getHttpName());
        if (this.parsedDLNAHeaders != null) {
            this.parsedDLNAHeaders.remove((Object)type);
        }
    }

    public UpnpHeader<?>[] getAsArray(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.get((Object)type) != null ? this.parsedDLNAHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedDLNAHeaders.get((Object)type).size()]) : new UpnpHeader[]{};
    }

    public UpnpHeader<?> getFirstHeader(DLNAHeader.Type type) {
        return this.getAsArray(type).length > 0 ? this.getAsArray(type)[0] : null;
    }

    public <H extends UpnpHeader<?>> H getFirstHeader(DLNAHeader.Type type, Class<H> subtype) {
        UpnpHeader<?>[] headers = this.getAsArray(type);
        if (headers.length == 0) {
            return null;
        }
        UpnpHeader<?>[] upnpHeaderArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            UpnpHeader<?> header = upnpHeaderArray[n2];
            if (subtype.isAssignableFrom(header.getClass())) {
                return (H)header;
            }
            ++n2;
        }
        return null;
    }

    public void log() {
        if (this.logger.isLoggable(Level.FINE)) {
            super.log();
            if (this.parsedDLNAHeaders != null && this.parsedDLNAHeaders.size() > 0) {
                this.logger.fine("########################## PARSED DLNA HEADERS ##########################");
                for (Map.Entry<DLNAHeader.Type, List<UpnpHeader<?>>> entry : this.parsedDLNAHeaders.entrySet()) {
                    this.logger.log(Level.FINE, "=== TYPE: {0}", (Object)entry.getKey());
                    for (UpnpHeader<?> upnpHeader : entry.getValue()) {
                        this.logger.log(Level.FINE, "HEADER: {0}", upnpHeader);
                    }
                }
            }
            this.logger.fine("####################################################################");
        }
    }
}

