/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.dlna.types.CodedDataBuffer;

public class BufferInfoType {
    private static final Pattern pattern = Pattern.compile("^dejitter=(\\d{1,10})(;CDB=(\\d{1,10});BTM=(0|1|2))?(;TD=(\\d{1,10}))?(;BFR=(0|1))?$", 2);
    private Long dejitterSize;
    private CodedDataBuffer cdb;
    private Long targetDuration;
    private Boolean fullnessReports;

    public BufferInfoType(Long dejitterSize) {
        this.dejitterSize = dejitterSize;
    }

    public BufferInfoType(Long dejitterSize, CodedDataBuffer cdb, Long targetDuration, Boolean fullnessReports) {
        this.dejitterSize = dejitterSize;
        this.cdb = cdb;
        this.targetDuration = targetDuration;
        this.fullnessReports = fullnessReports;
    }

    public static BufferInfoType valueOf(String s) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            try {
                Long dejitterSize = Long.parseLong(matcher.group(1));
                CodedDataBuffer cdb = null;
                Long targetDuration = null;
                Boolean fullnessReports = null;
                if (matcher.group(2) != null) {
                    cdb = new CodedDataBuffer(Long.parseLong(matcher.group(3)), CodedDataBuffer.TransferMechanism.values()[Integer.parseInt(matcher.group(4))]);
                }
                if (matcher.group(5) != null) {
                    targetDuration = Long.parseLong(matcher.group(6));
                }
                if (matcher.group(7) != null) {
                    fullnessReports = matcher.group(8).equals("1");
                }
                return new BufferInfoType(dejitterSize, cdb, targetDuration, fullnessReports);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new InvalidValueException("Can't parse BufferInfoType: " + s);
    }

    public String getString() {
        String s = "dejitter=" + this.dejitterSize.toString();
        if (this.cdb != null) {
            s = String.valueOf(s) + ";CDB=" + this.cdb.getSize().toString() + ";BTM=" + this.cdb.getTranfer().ordinal();
        }
        if (this.targetDuration != null) {
            s = String.valueOf(s) + ";TD=" + this.targetDuration.toString();
        }
        if (this.fullnessReports != null) {
            s = String.valueOf(s) + ";BFR=" + (this.fullnessReports != false ? "1" : "0");
        }
        return s;
    }

    public Long getDejitterSize() {
        return this.dejitterSize;
    }

    public CodedDataBuffer getCdb() {
        return this.cdb;
    }

    public Long getTargetDuration() {
        return this.targetDuration;
    }

    public Boolean isFullnessReports() {
        return this.fullnessReports;
    }
}

