/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking;

import com.google.common.base.Function;
import java.net.URL;
import java.util.List;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.sample.booking.AbstractBookingTestCase;

public class BookingTestCase
extends AbstractBookingTestCase {
    public static final int WAIT_TIME = 20;

    @Deployment
    public static WebArchive createDeployment() {
        return AbstractBookingTestCase.createDeployment();
    }

    @Test
    @InSequence(value=0)
    @RunAsClient
    public void login(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = deploymentURL.toURI().resolve("embed/BookingPortlet").toURL();
        this.driver.get(url.toString());
        WebElement loginForm = this.driver.findElement(By.className((String)"formLogin"));
        loginForm.findElement(By.name((String)"username")).sendKeys(new CharSequence[]{"demo"});
        loginForm.findElement(By.name((String)"password")).sendKeys(new CharSequence[]{"demo"});
        loginForm.submit();
        WebElement messageBoard = this.driver.findElement(By.className((String)"fSuccess"));
        Assert.assertNotNull((Object)messageBoard);
        Assert.assertEquals((String)"Welcome, Demo User", (String)messageBoard.getText());
        this.driver.get(url.toString());
    }

    @Test
    @InSequence(value=1)
    @RunAsClient
    public void searchHotels() throws Exception {
        WebElement findHotels = this.driver.findElement(By.className((String)"submit"));
        Assert.assertNotNull((Object)findHotels);
        findHotels.click();
        WebElement tbody = (WebElement)new WebDriverWait(this.driver, 10L).until((Function)new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver input) {
                return input.findElement(By.cssSelector((String)".result tbody"));
            }
        });
        List hotels = tbody.findElements(By.tagName((String)"tr"));
        Assert.assertEquals((int)5, (int)hotels.size());
        String[] expectedHotels = new String[]{"Marriott Courtyard", "Doubletree", "Hotel Rouge", "70 Park Avenue Hotel", "Conrad Miami"};
        for (int i = 0; i < hotels.size(); ++i) {
            Assert.assertEquals((String)expectedHotels[i], (String)((WebElement)((WebElement)hotels.get(i)).findElements(By.tagName((String)"td")).get(0)).getText());
        }
    }

    @Test
    @InSequence(value=2)
    @RunAsClient
    public void viewHotel() throws Exception {
        WebElement marriottHotel = (WebElement)this.driver.findElement(By.className((String)"result")).findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr")).get(0);
        Assert.assertNotNull((Object)marriottHotel);
        List hotelInfos = marriottHotel.findElements(By.tagName((String)"td"));
        Assert.assertEquals((String)"Marriott Courtyard", (String)((WebElement)hotelInfos.get(0)).getText());
        Assert.assertEquals((String)"Tower Place, Buckhead", (String)((WebElement)hotelInfos.get(1)).getText());
        Assert.assertEquals((String)"Atlanta, GA, USA", (String)((WebElement)hotelInfos.get(2)).getText());
        Assert.assertEquals((String)"30305", (String)((WebElement)hotelInfos.get(3)).getText());
        Assert.assertEquals((String)"View Hotel", (String)((WebElement)hotelInfos.get(4)).getText());
        WebElement viewHotel = ((WebElement)hotelInfos.get(4)).findElement(By.linkText((String)"View Hotel"));
        viewHotel.click();
    }

    @Test
    @InSequence(value=3)
    @RunAsClient
    public void bookHotel() throws Exception {
        WebElement bookLink = this.driver.findElement(By.className((String)"buttons")).findElement(By.linkText((String)"Book Hotel"));
        Assert.assertNotNull((Object)bookLink);
        bookLink.click();
        WebElement bookForm = this.driver.findElement(By.tagName((String)"form"));
        Assert.assertNotNull((Object)bookForm);
        bookForm.findElement(By.className((String)"buttons")).findElement(By.name((String)"confirm")).click();
    }

    @Test
    @InSequence(value=4)
    @RunAsClient
    public void checkBooking() throws Exception {
        WebElement success = this.driver.findElement(By.className((String)"fSuccess"));
        Assert.assertNotNull((Object)success);
        Assert.assertNotNull((String)"Thank you, demo, your confimation number for Marriott Courtyard is 0", (Object)success.findElement(By.tagName((String)"strong")).getText());
    }
}

