/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking.controllers;

import javax.inject.Inject;
import javax.validation.Valid;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.template.Template;
import org.sample.booking.Flash;
import org.sample.booking.controllers.Application_;
import org.sample.booking.controllers.Hotels;
import org.sample.booking.controllers.Login;
import org.sample.booking.models.User;

public class Application {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    @Path(value="register.gtmpl")
    Template register;
    @Inject
    Login login;
    @Inject
    Hotels hotels;
    @Inject
    Flash flash;

    @View
    @Route(value="/")
    public Response.Content index() {
        if (this.login.isConnected()) {
            return this.hotels.index();
        }
        return this.index.ok();
    }

    @View
    @Route(value="/register")
    public Response.Content register() {
        return this.register.ok();
    }

    @Action
    @Route(value="/register")
    public Response saveUser(@Valid User user, String verifyPassword) {
        User.create((User)user);
        this.login.setUserName(user.username);
        this.flash.setSuccess("Welcome, " + user.name);
        return Application_.index();
    }

    @Action
    @Route(value="/login")
    public Response login(User u) {
        System.out.println("Want login " + u.username + " " + u.password);
        User user = User.find((String)u.username, (String)u.password);
        if (user != null) {
            this.login.setUserName(user.username);
            this.flash.setSuccess("Welcome, " + user.name);
            return Application_.index();
        }
        this.flash.setUsername(u.username);
        this.flash.setError("Login failed");
        return null;
    }

    @Action
    @Route(value="/logout")
    public Response logout() {
        this.login.setUserName(null);
        return Application_.index();
    }
}

