/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking.controllers;

import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.validation.Valid;
import juzu.Action;
import juzu.Mapped;
import juzu.Path;
import juzu.PropertyType;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import org.sample.booking.Flash;
import org.sample.booking.controllers.Application_;
import org.sample.booking.controllers.Hotels_;
import org.sample.booking.controllers.Login;
import org.sample.booking.models.Booking;
import org.sample.booking.models.Hotel;
import org.sample.booking.models.User;
import org.sample.booking.templates.hotels.book;
import org.sample.booking.templates.hotels.confirmBooking;
import org.sample.booking.templates.hotels.index;
import org.sample.booking.templates.hotels.list;
import org.sample.booking.templates.hotels.show;

public class Hotels {
    @Inject
    Login login;
    @Inject
    Flash flash;
    @Inject
    @Path(value="hotels/index.gtmpl")
    index index;
    @Inject
    @Path(value="hotels/list.gtmpl")
    list list;
    @Inject
    @Path(value="hotels/book.gtmpl")
    book book;
    @Inject
    @Path(value="hotels/show.gtmpl")
    show show;
    @Inject
    @Path(value="hotels/confirmBooking.gtmpl")
    confirmBooking confirmBooking;

    public Response.Content index() {
        String username = this.login.getUserName();
        List bookings = Booking.findByUser((String)username);
        return this.index.with().bookings((Object)bookings).ok();
    }

    @Ajax
    @Resource
    @Route(value="/hotels")
    public Response.Content list(String search, String size, String page) {
        int _size = size != null ? Integer.parseInt(size) : 5;
        int _page = page != null ? Integer.parseInt(page) : 0;
        Pattern pattern = search != null && search.trim().length() > 0 ? Pattern.compile(".*" + Pattern.quote(search.trim()) + ".*", 2) : Pattern.compile(".*");
        List hotels = Hotel.find((Pattern)pattern, (Pattern)pattern, (int)_size, (int)_page);
        return this.list.with().hotels((Object)hotels).page((Object)_page).ok();
    }

    @View
    @Route(value="/hotels/{id}")
    public Response.Content show(String id) {
        Hotel hotel = Hotel.findById((String)id);
        return this.show.with().hotel((Object)hotel).ok();
    }

    @View
    @Route(value="/hotels/{id}/booking")
    public Response.Content book(String id, @Mapped Booking booking) {
        Hotel hotel = Hotel.findById((String)id);
        if (booking == null) {
            booking = new Booking();
        }
        return this.book.with().hotel((Object)hotel).booking((Object)booking).ok();
    }

    @Action
    @Route(value="/hotels/{id}/booking")
    public Response processConfirmBooking(String confirm, String id, String revise, @Mapped @Valid Booking booking) {
        Hotel hotel = Hotel.findById((String)id);
        User user = User.find((String)this.login.getUserName(), null);
        booking.hotel = hotel;
        booking.user = user;
        if (revise != null) {
            return Hotels_.book((String)id, (Booking)booking);
        }
        if (confirm != null) {
            booking.create();
            this.flash.setSuccess("Thank you, " + this.login.getUserName() + ", your confimation number for " + hotel.name + " is " + booking.id);
            return Application_.index();
        }
        return Hotels_.confirmBooking((String)id, (Booking)booking).with(PropertyType.REDIRECT_AFTER_ACTION, (Object)false);
    }

    @View
    @Route(value="/hotels/{id}/confirm")
    public Response.Content confirmBooking(String id, @Mapped Booking booking) {
        Hotel hotel = Hotel.findById((String)id);
        return this.confirmBooking.with().total((Object)0).hotel((Object)hotel).booking((Object)booking).ok();
    }

    @Action
    @Route(value="/bookings/{id}")
    public Response cancelBooking(String id) {
        Booking booking = Booking.find((String)id);
        booking.delete();
        this.flash.setSuccess("Booking cancelled for confirmation number " + id);
        return Application_.index();
    }

    @View
    @Route(value="/settings")
    public void settings() {
        throw new UnsupportedOperationException("todo settings.gtmpl");
    }
}

