/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.sample.booking.AbstractBookingTestCase;

public class RegistrationTestCase
extends AbstractBookingTestCase {
    @Deployment
    public static WebArchive createDeployment() {
        return AbstractBookingTestCase.createDeployment();
    }

    @Test
    @InSequence(value=0)
    @RunAsClient
    public void registerUser(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = deploymentURL.toURI().resolve("embed/BookingPortlet").toURL();
        this.driver.get(url.toString());
        WebElement registerLink = this.driver.findElement(By.linkText((String)"Register New User"));
        Assert.assertNotNull((Object)registerLink);
        registerLink.click();
        WebElement registerForm = this.driver.findElement(By.tagName((String)"form"));
        Assert.assertNotNull((Object)registerForm);
        registerForm.findElement(By.name((String)"username")).sendKeys(new CharSequence[]{"testUser"});
        registerForm.findElement(By.name((String)"name")).sendKeys(new CharSequence[]{"testUserName"});
        registerForm.findElement(By.name((String)"password")).sendKeys(new CharSequence[]{"testUserPassword"});
        registerForm.findElement(By.name((String)"verifyPassword")).sendKeys(new CharSequence[]{"testUserPassword"});
        registerForm.submit();
        WebElement messageBoard = this.driver.findElement(By.className((String)"fSuccess"));
        Assert.assertNotNull((Object)messageBoard);
        Assert.assertEquals((String)"Welcome, testUserName", (String)messageBoard.getText());
    }
}

