/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler.file;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.JavaFileObjectImpl;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager<P> {
    final ReadFileSystem<P> fs;
    final Map<FileKey, JavaFileObjectImpl<P>> entries;

    public FileManager(ReadFileSystem<P> fs) {
        this.fs = fs;
        this.entries = new HashMap<FileKey, JavaFileObjectImpl<P>>();
    }

    public ReadFileSystem<P> getFileSystem() {
        return this.fs;
    }

    public void clearCache() {
        this.entries.clear();
    }

    public JavaFileObject getReadable(FileKey key) throws IOException {
        P file;
        P dir;
        JavaFileObjectImpl<P> entry = this.entries.get(key);
        if (entry == null && (dir = this.fs.getDir(key.packageNames)) != null && (file = this.fs.getChild(dir, key.name)) != null) {
            entry = new JavaFileObjectImpl<P>(key, this, file);
            this.entries.put(key, entry);
        }
        return entry;
    }

    public JavaFileObject getWritable(FileKey key) throws IOException {
        if (this.fs instanceof ReadWriteFileSystem) {
            ReadWriteFileSystem rwFS = (ReadWriteFileSystem)this.fs;
            JavaFileObjectImpl<P> entry = this.entries.get(key);
            if (entry == null) {
                Object file = rwFS.getFile(key.packageNames, key.name);
                entry = new JavaFileObjectImpl(key, this, file);
                this.entries.put(key, entry);
            }
            return entry;
        }
        throw new UnsupportedOperationException("File system is not writable");
    }

    public void list(String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse, Collection<JavaFileObject> to) throws IOException {
        Iterable<String> packageNames = Spliterator.split(packageName, '.');
        P dir = this.fs.getDir(packageNames);
        if (dir != null) {
            this.list(dir, kinds, recurse, to);
        }
    }

    public void list(P root, Set<JavaFileObject.Kind> kinds, boolean recurse, Collection<JavaFileObject> to) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.fs.packageOf(root, '.', sb);
        String packageName = sb.toString();
        Iterator<P> i = this.fs.getChildren(root);
        while (i.hasNext()) {
            P child = i.next();
            if (this.fs.isDir(child)) {
                if (!recurse) continue;
                this.list(child, kinds, true, to);
                continue;
            }
            String name = this.fs.getName(child);
            FileKey key = FileKey.newName(packageName, name);
            if (!kinds.contains((Object)key.kind)) continue;
            to.add(this.getReadable(key));
        }
    }
}

