/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.fs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.juzu.impl.fs.Change;
import org.juzu.impl.fs.Visitor;
import org.juzu.impl.spi.fs.ReadFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemScanner<P>
implements Visitor<P> {
    private ReadFileSystem<P> fs;
    private StringBuilder sb = new StringBuilder();
    private Map<String, Data> snapshot = new HashMap<String, Data>();

    public FileSystemScanner(ReadFileSystem<P> fs) {
        this.fs = fs;
    }

    public Map<String, Change> scan() throws IOException {
        for (Data data : this.snapshot.values()) {
            data.change = Change.REMOVE;
        }
        this.fs.traverse(this);
        LinkedHashMap<String, Change> changes = new LinkedHashMap<String, Change>();
        Iterator<Map.Entry<String, Data>> i = this.snapshot.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Data> entry = i.next();
            Data data = entry.getValue();
            if (data.change == null) continue;
            changes.put(entry.getKey(), data.change);
            if (data.change != Change.REMOVE) continue;
            i.remove();
        }
        return changes;
    }

    @Override
    public boolean enterDir(P dir, String name) throws IOException {
        return true;
    }

    @Override
    public void file(P file, String name) throws IOException {
        long lastModified = this.fs.getLastModified(file);
        this.fs.pathOf(file, '/', this.sb);
        String id = this.sb.toString();
        this.sb.setLength(0);
        Data data = this.snapshot.get(id);
        if (data == null) {
            this.snapshot.put(id, new Data(lastModified));
        } else if (data.lastModified < lastModified) {
            data.lastModified = lastModified;
            data.change = Change.UPDATE;
        } else {
            data.change = null;
        }
    }

    @Override
    public void leaveDir(P dir, String name) throws IOException {
    }

    private static class Data {
        private long lastModified;
        private Change change;

        private Data(long lastModified) {
            this.lastModified = lastModified;
            this.change = Change.ADD;
        }
    }
}

