/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.processor.ApplicationModel;
import org.juzu.impl.processor.ErrorCode;
import org.juzu.impl.processor.Foo;
import org.juzu.impl.processor.MainProcessor;
import org.juzu.impl.processor.TemplateModel;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.ParseException;
import org.juzu.impl.template.TemplateCompilationContext;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler
extends TemplateCompilationContext {
    private final ApplicationModel application;
    private Foo foo;
    private final MainProcessor processor;
    private final ArrayList<TemplateModel> added;
    private static final StandardLocation[] locations = new StandardLocation[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT};

    public TemplateCompiler(ApplicationModel application, Foo foo, MainProcessor processor) {
        this.application = application;
        this.foo = foo;
        this.processor = processor;
        this.added = new ArrayList();
    }

    private void process(ASTNode.Template template) throws IOException {
        template.process(this);
    }

    public Iterable<TemplateModel> getAdded() {
        return this.added;
    }

    @Override
    public String resolveTemplate(String path) throws IOException {
        TemplateModel template = this.application.templates.get(path);
        if (template == null) {
            ASTNode.Template templateAST;
            Foo foo = new Foo(this.foo, path);
            String fqn = this.application.templatesFQN;
            for (String name : Spliterator.split(foo.getFolder() + foo.getRawName(), '/')) {
                if (fqn.length() == 0) {
                    fqn = name;
                    continue;
                }
                fqn = fqn + "." + name;
            }
            FQN stubFQN = new FQN(fqn);
            CharSequence content = null;
            Exception exception = null;
            for (StandardLocation location : locations) {
                try {
                    String pkg = stubFQN.getPackageName();
                    String relativeName = stubFQN.getSimpleName() + "." + foo.getExtension();
                    MainProcessor.log("Attempt to obtain template " + pkg + " " + relativeName + " from " + location.getName());
                    FileObject resource = this.processor.filer.getResource(location, pkg, relativeName);
                    content = resource.getCharContent(true);
                    if (content == null) continue;
                    MainProcessor.log("Obtained template e " + resource.toUri() + " from " + location.getName());
                    break;
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (content == null) {
                throw new CompilationException((Throwable)exception, MainProcessor.get(foo.getOrigin()), ErrorCode.TEMPLATE_NOT_FOUND, stubFQN);
            }
            try {
                templateAST = ASTNode.Template.parse(content);
            }
            catch (ParseException e) {
                throw new CompilationException(MainProcessor.get(foo.getOrigin()), ErrorCode.TEMPLATE_SYNTAX_ERROR, fqn);
            }
            template = new TemplateModel(foo, templateAST, stubFQN);
            this.application.templates.put(path, template);
            this.process(templateAST);
            this.added.add(template);
        }
        return template.getStubFQN().getFullName();
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) {
        throw new UnsupportedOperationException();
    }
}

