/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.disk;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.spi.fs.disk.FilterImpl;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskFileSystem
extends ReadWriteFileSystem<File> {
    private final File root;
    private FilenameFilter filter;
    private Charset encoding;

    public DiskFileSystem(File root) {
        this(root, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }

    public DiskFileSystem(File root, FilenameFilter filter) {
        this.root = root;
        this.filter = filter;
        this.encoding = Charset.defaultCharset();
    }

    public DiskFileSystem(File root, String ... path) {
        this(root, new FilterImpl(root, path));
    }

    public void applyFilter(String ... path) {
        this.filter = new FilterImpl(this.root, path);
    }

    @Override
    public boolean equals(File left, File right) {
        return left.equals(right);
    }

    @Override
    public File getRoot() throws IOException {
        return this.root;
    }

    @Override
    public File getParent(File path) throws IOException {
        if (path.equals(this.root)) {
            return null;
        }
        return path.getParentFile();
    }

    @Override
    public boolean isDir(File path) throws IOException {
        return path.isDirectory();
    }

    @Override
    public boolean isFile(File path) throws IOException {
        return path.isFile();
    }

    @Override
    public String getName(File path) throws IOException {
        if (path.equals(this.root)) {
            return "";
        }
        return path.getName();
    }

    @Override
    public Iterator<File> getChildren(File dir) throws IOException {
        return Arrays.asList(dir.listFiles(this.filter)).iterator();
    }

    @Override
    public File getChild(File dir, String name) throws IOException {
        File child;
        if (this.filter.accept(dir, name) && (child = new File(dir, name)).exists()) {
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getContent(File file) throws IOException {
        Content content;
        FileInputStream in = new FileInputStream(file);
        try {
            ByteArrayOutputStream content2 = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            int l = in.read(buffer);
            while (l != -1) {
                content2.write(buffer, 0, l);
                l = in.read(buffer);
            }
            content = new Content(file.lastModified(), content2.toByteArray(), this.encoding);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return content;
    }

    @Override
    public long getLastModified(File path) throws IOException {
        return path.lastModified();
    }

    @Override
    public URL getURL(File path) throws IOException {
        return path.toURI().toURL();
    }

    @Override
    public File getFile(File path) throws IOException {
        return path;
    }

    @Override
    public File addDir(File parent, String name) throws IOException {
        File dir = new File(parent, name);
        dir.mkdir();
        return dir;
    }

    @Override
    public File addFile(File parent, String name) throws IOException {
        return new File(parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(File file, Content content) throws IOException {
        InputStream in = content.getInputStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            Tools.copy(in, out);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
    }
}

