/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.spring;

import org.juzu.AmbiguousResolutionException;
import org.juzu.impl.spi.inject.InjectManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringManager
implements InjectManager<String, Object> {
    private final DefaultListableBeanFactory factory;
    private final ClassLoader classLoader;

    public SpringManager(DefaultListableBeanFactory factory, ClassLoader classLoader) {
        factory.registerSingleton("" + Math.random(), (Object)this);
        this.factory = factory;
        this.classLoader = classLoader;
    }

    @Override
    public String getImplementation() {
        return "inject/spring";
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String resolveBean(Class<?> type) {
        String[] names = this.factory.getBeanNamesForType(type);
        switch (names.length) {
            case 0: {
                return null;
            }
            case 1: {
                return names[0];
            }
        }
        throw new AmbiguousResolutionException();
    }

    @Override
    public String resolveBean(String name) {
        try {
            this.factory.getBeanDefinition(name);
            return name;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    @Override
    public Object create(String bean) {
        return this.factory.getBean(bean);
    }

    @Override
    public Object get(String bean, Object instance) {
        return instance;
    }

    @Override
    public void release(Object instance) {
    }
}

