/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.juzu.Path;
import org.juzu.impl.utils.Tools;
import org.juzu.metadata.ControllerDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.TemplateDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor {
    private final String packageName;
    private final String name;
    private Class<?> defaultController;
    private final List<ControllerDescriptor> controllers;
    private final List<ControllerMethod> controllerMethods;
    private final String templatesPackageName;
    private final List<TemplateDescriptor> templates;

    protected ApplicationDescriptor(Class<?> defaultController, String templatesPackageName) {
        Properties props;
        Class<?> applicationClass = this.getClass();
        InputStream in = null;
        try {
            in = applicationClass.getResourceAsStream("config.properties");
            props = new Properties();
            props.load(in);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            Tools.safeClose(in);
        }
        ArrayList<ControllerDescriptor> controllers = new ArrayList<ControllerDescriptor>();
        ArrayList<ControllerMethod> controllerMethods = new ArrayList<ControllerMethod>();
        ArrayList<TemplateDescriptor> templates = new ArrayList<TemplateDescriptor>();
        for (Object o : props.keySet()) {
            String controllerFQN = o.toString();
            String value = props.getProperty(controllerFQN);
            try {
                Class<?> clazz = applicationClass.getClassLoader().loadClass(controllerFQN);
                if ("controller".equals(value)) {
                    Field f = clazz.getField("INSTANCE");
                    ControllerDescriptor controller = (ControllerDescriptor)f.get(null);
                    controllers.add(controller);
                    controllerMethods.addAll(controller.getMethods());
                    continue;
                }
                if (!"template".equals(value)) continue;
                Path path = clazz.getAnnotation(Path.class);
                templates.add(new TemplateDescriptor(path.value(), clazz));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        this.name = applicationClass.getSimpleName();
        this.packageName = applicationClass.getPackage().getName();
        this.templatesPackageName = templatesPackageName;
        this.defaultController = defaultController;
        this.controllers = controllers;
        this.controllerMethods = controllerMethods;
        this.templates = templates;
    }

    public ApplicationDescriptor(String packageName, String name, Class<?> defaultController, String templatesPackageName, List<ControllerDescriptor> controllers, List<TemplateDescriptor> templates) {
        ArrayList<ControllerMethod> foo = new ArrayList<ControllerMethod>();
        for (ControllerDescriptor controller : controllers) {
            for (ControllerMethod method : controller.getMethods()) {
                foo.add(method);
            }
        }
        this.defaultController = defaultController;
        this.packageName = packageName;
        this.name = name;
        this.templatesPackageName = templatesPackageName;
        this.controllers = Collections.unmodifiableList(controllers);
        this.controllerMethods = Collections.unmodifiableList(foo);
        this.templates = Collections.unmodifiableList(templates);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getDefaultController() {
        return this.defaultController;
    }

    public List<ControllerDescriptor> getControllers() {
        return this.controllers;
    }

    public List<ControllerMethod> getControllerMethods() {
        return this.controllerMethods;
    }

    public List<TemplateDescriptor> getTemplates() {
        return this.templates;
    }

    public ControllerMethod getControllerMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (int i = 0; i < this.controllerMethods.size(); ++i) {
            Class<?>[] a;
            ControllerMethod cm = this.controllerMethods.get(i);
            Method m = cm.getMethod();
            if (!type.equals(cm.getType()) || !m.getName().equals(name) || (a = m.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (a[j].equals(parameterTypes[j])) continue;
            }
            return cm;
        }
        return null;
    }

    public ControllerMethod getControllerMethodById(String methodId) {
        for (int i = 0; i < this.controllerMethods.size(); ++i) {
            ControllerMethod cm = this.controllerMethods.get(i);
            if (!cm.getId().equals(methodId)) continue;
            return cm;
        }
        return null;
    }

    public String getTemplatesPackageName() {
        return this.templatesPackageName;
    }
}

