/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.FileManager;
import org.juzu.impl.compiler.file.SimpleFileManager;
import org.juzu.impl.spi.fs.SimpleFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFileManager
extends FileManager {
    private FileManager[] components;

    public CompositeFileManager(Collection<SimpleFileSystem<?>> fsList) {
        FileManager[] components = new FileManager[fsList.size()];
        int index = 0;
        for (SimpleFileSystem<?> fs : fsList) {
            components[index++] = SimpleFileManager.wrap(fs);
        }
        this.components = components;
    }

    @Override
    public JavaFileObject getReadable(FileKey key) throws IOException {
        for (FileManager component : this.components) {
            JavaFileObject readable = component.getReadable(key);
            if (readable == null) continue;
            return readable;
        }
        return null;
    }

    @Override
    public JavaFileObject getWritable(FileKey key) throws IOException {
        for (FileManager component : this.components) {
            JavaFileObject writable = component.getWritable(key);
            if (writable == null) continue;
            return writable;
        }
        return null;
    }

    @Override
    public <C extends Collection<JavaFileObject>> C list(String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse, C to) throws IOException {
        for (FileManager component : this.components) {
            component.list(packageName, kinds, recurse, to);
        }
        return to;
    }

    @Override
    public void clearCache() {
        for (FileManager component : this.components) {
            component.clearCache();
        }
    }
}

