/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.inject;

import org.juzu.impl.inject.ScopingContext;
import org.juzu.impl.request.Scope;

public class ScopeController {
    public static final ScopeController INSTANCE = new ScopeController();
    final ThreadLocal<ScopingContext> currentContext = new ThreadLocal();

    public static void begin(ScopingContext context) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (ScopeController.INSTANCE.currentContext.get() != null) {
            throw new IllegalStateException("Already started");
        }
        ScopeController.INSTANCE.currentContext.set(context);
    }

    public static void end() {
        ScopeController.INSTANCE.currentContext.set(null);
    }

    private ScopeController() {
    }

    public Object get(Scope scope, Object key) throws IllegalStateException {
        ScopingContext ctx = this.currentContext.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not active");
        }
        if (!ctx.isActive(scope)) {
            throw new IllegalStateException("Context not active");
        }
        return ctx.getContextualValue(scope, key);
    }

    public void put(Scope scope, Object key, Object object) throws IllegalStateException {
        ScopingContext ctx = this.currentContext.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not active");
        }
        if (!ctx.isActive(scope)) {
            throw new IllegalStateException("Context not active");
        }
        ctx.setContextualValue(scope, key, object);
    }

    public boolean isActive(Scope scope) {
        ScopingContext ctx = this.currentContext.get();
        return ctx != null && ctx.isActive(scope);
    }
}

