/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.MetaModel;
import org.juzu.impl.model.meta.MetaModelObject;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMetaModel
extends MetaModelObject {
    boolean modified;
    final MetaModel context;
    ApplicationMetaModel application;
    final ElementHandle.Class handle;
    final LinkedHashMap<ElementHandle.Method, MethodMetaModel> methods;

    public ControllerMetaModel(MetaModel context, ElementHandle.Class handle) {
        this.context = context;
        this.handle = handle;
        this.methods = new LinkedHashMap();
        this.modified = false;
    }

    @Override
    public Map<String, ?> toJSON() {
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("handle", this.handle);
        ArrayList foo = new ArrayList();
        for (MethodMetaModel method : this.methods.values()) {
            foo.add(method.toJSON());
        }
        json.put("methods", foo);
        json.put("application", this.application == null ? null : this.application.handle);
        return json;
    }

    public ApplicationMetaModel getApplication() {
        return this.application;
    }

    public ElementHandle.Class getHandle() {
        return this.handle;
    }

    public List<MethodMetaModel> getMethods() {
        return new ArrayList<MethodMetaModel>(this.methods.values());
    }

    public MethodMetaModel addMethod(Phase phase, String name, Iterable<Map.Entry<String, String>> parameters) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters) {
            parameterTypes.add(entry.getValue());
            parameterNames.add(entry.getKey());
        }
        ElementHandle.Method handle = ElementHandle.Method.create(this.handle.getFQN(), name, parameterTypes);
        if (this.methods.containsKey(handle)) {
            throw new IllegalStateException();
        }
        MethodMetaModel method = new MethodMetaModel(handle, this, "" + Math.random(), phase, name, parameterTypes, parameterNames);
        this.methods.put(handle, method);
        return method;
    }

    /*
     * WARNING - void declaration
     */
    void addMethod(ExecutableElement methodElt, String annotationName, Map<String, Object> annotationValues) {
        void var7_10;
        String id = (String)annotationValues.get("id");
        if (id == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodElt.getEnclosingElement().getSimpleName());
            sb.append("_");
            sb.append(methodElt.getSimpleName());
            for (VariableElement variableElement : methodElt.getParameters()) {
                sb.append("_").append(variableElement.getSimpleName());
            }
            id = sb.toString();
        }
        Phase[] arr$ = Phase.values();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_10 < len$) {
            Phase phase = arr$[var7_10];
            if (phase.annotation.getSimpleName().equals(annotationName)) {
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (TypeMirror typeMirror : ((ExecutableType)methodElt.asType()).getParameterTypes()) {
                    TypeMirror typeMirror2 = this.context.env.erasure(typeMirror);
                    parameterTypes.add(((Object)typeMirror2).toString());
                }
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (VariableElement variableElement : methodElt.getParameters()) {
                    parameterNames.add(variableElement.getSimpleName().toString());
                }
                ElementHandle.Method method = ElementHandle.Method.create(methodElt);
                this.methods.remove(method);
                for (MethodMetaModel existing : this.methods.values()) {
                    if (!existing.id.equals(id)) continue;
                    throw new CompilationException(methodElt, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_DUPLICATE_ID, id);
                }
                MethodMetaModel methodMetaModel = new MethodMetaModel(method, this, id, phase, methodElt.getSimpleName().toString(), parameterTypes, parameterNames);
                this.methods.put(method, methodMetaModel);
                this.modified = true;
                break;
            }
            ++var7_10;
        }
    }
}

