/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.MetaModelEvent;
import org.juzu.impl.model.meta.MetaModelObject;
import org.juzu.impl.model.meta.TemplateRefMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateMetaModel
extends MetaModelObject {
    final LinkedHashMap<ElementHandle.Field, TemplateRefMetaModel> refs;
    ApplicationMetaModel application;
    final String path;

    public TemplateMetaModel(ApplicationMetaModel application, TemplateRefMetaModel ref) {
        this.application = application;
        this.path = ref.path;
        this.refs = new LinkedHashMap();
    }

    public ApplicationMetaModel getApplication() {
        return this.application;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Map<String, ?> toJSON() {
        TreeMap<String, Object> json = new TreeMap<String, Object>();
        json.put("path", this.path);
        json.put("refs", new HashSet<ElementHandle.Field>(this.refs.keySet()));
        json.put("application", this.application.fqn);
        return json;
    }

    public Collection<TemplateRefMetaModel> getRefs() {
        return new ArrayList<TemplateRefMetaModel>(this.refs.values());
    }

    public TemplateMetaModel addRef(TemplateRefMetaModel ref) {
        if (ref.template != null) {
            throw new IllegalArgumentException();
        }
        if (this.refs.containsKey(ref.handle)) {
            throw new IllegalStateException();
        }
        if (!this.path.equals(ref.path)) {
            throw new IllegalArgumentException(this.path + " != " + ref.path);
        }
        this.refs.put(ref.handle, ref);
        ref.template = this;
        this.application.model.queue(new MetaModelEvent(0, ref));
        return this;
    }

    public void removeRef(TemplateRefMetaModel ref) {
        if (ref.template != this) {
            throw new IllegalArgumentException();
        }
        if (!this.refs.containsKey(ref.handle)) {
            throw new IllegalStateException();
        }
        this.application.model.queue(new MetaModelEvent(1, ref));
        this.refs.remove(ref.handle);
        ref.template = null;
    }
}

