/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.resolver;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.lang.model.element.VariableElement;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.processor.ProcessingContext;
import org.juzu.impl.model.resolver.ModelResolver;
import org.juzu.impl.model.resolver.Template;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.ParseException;
import org.juzu.impl.template.TemplateCompilationContext;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateCompiler {
    private TemplateMetaModel templateMetaModel;
    private final Map<String, Template> templates;
    private ArrayList<Template> added;
    private final ProcessingContext env;
    private final TemplateCompilationContext context = new TemplateCompilationContext(){

        @Override
        public void resolveTemplate(String path) {
            Template template = (Template)TemplateCompiler.this.templates.get(path);
            if (template == null) {
                ASTNode.Template templateAST;
                Matcher matcher = ModelResolver.TEMPLATE_PATH_PATTERN.matcher(path);
                if (!matcher.matches()) {
                    VariableElement elt = TemplateCompiler.this.env.get(TemplateCompiler.this.templateMetaModel.getRefs().iterator().next().getHandle());
                    throw new CompilationException(elt, (ErrorCode)CompilationErrorCode.TEMPLATE_ILLEGAL_PATH, path);
                }
                String folder = matcher.group(1);
                String rawName = matcher.group(2);
                String extension = matcher.group(3);
                String fqn = TemplateCompiler.this.templateMetaModel.getApplication().getTemplatesQN().getValue();
                for (String name : Spliterator.split(folder + rawName, '/')) {
                    if (fqn.length() == 0) {
                        fqn = name;
                        continue;
                    }
                    fqn = fqn + "." + name;
                }
                FQN stubFQN = new FQN(fqn);
                Content content = TemplateCompiler.this.env.resolveResource(stubFQN, extension);
                if (content == null) {
                    throw new CompilationException(TemplateCompiler.this.env.get(TemplateCompiler.this.templateMetaModel.getRefs().iterator().next().getHandle()), (ErrorCode)CompilationErrorCode.TEMPLATE_NOT_RESOLVED, fqn);
                }
                try {
                    templateAST = ASTNode.Template.parse(content.getCharSequence());
                }
                catch (ParseException e) {
                    VariableElement elt = TemplateCompiler.this.env.get(TemplateCompiler.this.templateMetaModel.getRefs().iterator().next().getHandle());
                    throw new CompilationException(elt, (ErrorCode)CompilationErrorCode.TEMPLATE_SYNTAX_ERROR, template.getPath());
                }
                ArrayList paramTags = new ArrayList();
                TemplateCompiler.this.collectParams(templateAST, paramTags);
                LinkedHashSet<String> parameters = null;
                if (paramTags.size() > 0) {
                    parameters = new LinkedHashSet<String>();
                    for (ASTNode.Tag paramTag : paramTags) {
                        String paramName = paramTag.getArgs().get("name");
                        parameters.add(paramName);
                    }
                }
                template = new Template(TemplateCompiler.this.templateMetaModel.getPath(), templateAST, stubFQN, extension, path, parameters, content.getLastModified());
                TemplateCompiler.this.templates.put(path, template);
                templateAST.process(this);
                TemplateCompiler.this.added.add(template);
            }
        }

        @Override
        public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) {
            throw new UnsupportedOperationException();
        }
    };

    TemplateCompiler(TemplateMetaModel templateMetaModel, Map<String, Template> templates, ProcessingContext env) {
        this.templateMetaModel = templateMetaModel;
        this.templates = templates;
        this.env = env;
    }

    List<Template> resolve() {
        this.added = new ArrayList();
        this.context.resolveTemplate(this.templateMetaModel.getPath());
        return this.added;
    }

    private void collectParams(ASTNode<?> node, List<ASTNode.Tag> tags) {
        ASTNode.Tag tag;
        for (ASTNode.Block<?> child : node.getChildren()) {
            this.collectParams(child, tags);
        }
        if (node instanceof ASTNode.Tag && (tag = (ASTNode.Tag)node).getName().equals("param")) {
            tags.add(tag);
        }
    }
}

