/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.war;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WarFileSystem
extends ReadFileSystem<String> {
    private final String mountPoint;

    public WarFileSystem(String mountPoint) throws NullPointerException {
        if (mountPoint == null) {
            throw new NullPointerException("No null mount point accepted");
        }
        if (!mountPoint.startsWith("/") || !mountPoint.endsWith("/")) {
            throw new IllegalArgumentException("Invalid mount point " + mountPoint);
        }
        this.mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
    }

    @Override
    public boolean equals(String left, String right) {
        return left.equals(right);
    }

    @Override
    public String getRoot() throws IOException {
        return "/";
    }

    @Override
    public String getParent(String path) throws IOException {
        int index;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(47)) == -1) {
            return null;
        }
        return path.substring(0, index + 1);
    }

    @Override
    public String getName(String path) throws IOException {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public Iterator<String> getChildren(String dir) throws IOException {
        return this.getResourcePaths(dir).iterator();
    }

    @Override
    public String getChild(String dir, String name) throws IOException {
        Iterator<String> i = this.getChildren(dir);
        while (i.hasNext()) {
            String child = i.next();
            String childName = this.getName(child);
            if (!childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean isDir(String path) throws IOException {
        return path.endsWith("/");
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return !this.isDir(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getContent(String file) throws IOException {
        URL url = this.getResource(file);
        if (url != null) {
            Content content;
            URLConnection conn = url.openConnection();
            long lastModified = conn.getLastModified();
            InputStream in = conn.getInputStream();
            try {
                ByteArrayOutputStream content2 = new ByteArrayOutputStream();
                byte[] buffer = new byte[256];
                int l = in.read(buffer);
                while (l != -1) {
                    content2.write(buffer, 0, l);
                    l = in.read(buffer);
                }
                content = new Content(lastModified, content2.toByteArray(), Charset.defaultCharset());
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                Tools.safeClose(in);
                throw throwable;
            }
            Tools.safeClose(in);
            return content;
        }
        throw new UnsupportedOperationException("handle me gracefully");
    }

    @Override
    public long getLastModified(String path) throws IOException {
        URL url = this.getResource(path);
        URLConnection conn = url.openConnection();
        return conn.getLastModified();
    }

    @Override
    public URL getURL(String path) throws IOException {
        return this.getResource(path);
    }

    protected abstract Set<String> doGetResourcePaths(String var1) throws IOException;

    protected abstract URL doGetResource(String var1) throws IOException;

    protected abstract String doGetRealPath(String var1) throws IOException;

    private Collection<String> getResourcePaths(String path) throws IOException {
        Set<String> resourcePaths = this.doGetResourcePaths(this.mountPoint + path);
        if (resourcePaths != null) {
            ArrayList<String> tmp = new ArrayList<String>(resourcePaths.size());
            for (String resourcePath : resourcePaths) {
                tmp.add(resourcePath.substring(this.mountPoint.length()));
            }
            return tmp;
        }
        return Collections.emptyList();
    }

    @Override
    public File getFile(String path) throws IOException {
        String realPath = this.doGetRealPath(this.mountPoint + path);
        return realPath == null ? null : new File(realPath);
    }

    private URL getResource(String path) throws IOException {
        return this.doGetResource(this.mountPoint + path);
    }

    public static WarFileSystem create(ServletContext context) {
        return WarFileSystem.create(context, "/");
    }

    public static WarFileSystem create(final ServletContext servletContext, String mountPoint) {
        return new WarFileSystem(mountPoint){

            @Override
            protected Set<String> doGetResourcePaths(String path) throws IOException {
                return servletContext.getResourcePaths(path);
            }

            @Override
            protected URL doGetResource(String path) throws IOException {
                String realPath = servletContext.getRealPath(path);
                if (realPath != null) {
                    return new File(realPath).toURI().toURL();
                }
                return servletContext.getResource(path);
            }

            @Override
            protected String doGetRealPath(String path) throws IOException {
                return servletContext.getRealPath(path);
            }
        };
    }

    public static WarFileSystem create(PortletContext portletContext) {
        return WarFileSystem.create(portletContext, "/");
    }

    public static WarFileSystem create(final PortletContext portletContext, String mountPoint) {
        return new WarFileSystem(mountPoint){

            @Override
            protected Set<String> doGetResourcePaths(String path) throws IOException {
                return portletContext.getResourcePaths(path);
            }

            @Override
            protected URL doGetResource(String path) throws IOException {
                String realPath = portletContext.getRealPath(path);
                if (realPath != null) {
                    return new File(realPath).toURI().toURL();
                }
                return portletContext.getResource(path);
            }

            @Override
            protected String doGetRealPath(String path) throws IOException {
                return portletContext.getRealPath(path);
            }
        };
    }
}

