/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.Serializable;

public class QN
implements CharSequence,
Serializable {
    private final String value;

    public QN(CharSequence value) throws NullPointerException, IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length() > 0) {
            if (value.charAt(0) == '.') {
                throw new IllegalArgumentException("A qualified name cannot begin with '.' : " + value);
            }
            if (value.length() > 1) {
                if (value.charAt(value.length() - 1) == '.') {
                    throw new IllegalArgumentException("A qualified name cannot end with '.' : " + value);
                }
                if (value.length() > 3) {
                    char prev = value.charAt(1);
                    for (int i = 2; i < value.length() - 1; ++i) {
                        char next = value.charAt(i);
                        if (prev == '.' && next == '.') {
                            throw new IllegalArgumentException("A qualified name cannot have two following '.' : " + value);
                        }
                        prev = next;
                    }
                }
            }
        }
        this.value = ((Object)value).toString();
    }

    public String getValue() {
        return this.value;
    }

    public QN append(String simpleName) throws NullPointerException, IllegalArgumentException {
        if (simpleName == null) {
            throw new NullPointerException("No null simple name accepted");
        }
        if (simpleName.isEmpty()) {
            throw new IllegalArgumentException("No empty simple name can be appended");
        }
        if (simpleName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A simple name cannot contain a '.'");
        }
        if (this.value.isEmpty()) {
            return new QN(simpleName);
        }
        return new QN(this.value + "." + simpleName);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public int length() {
        return this.value.length();
    }

    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public String toString() {
        return this.value;
    }

    public boolean isPrefix(QN qn) {
        return this.value.length() == 0 || qn.value.startsWith(this.value) && (qn.value.length() == this.value.length() || qn.value.charAt(this.value.length()) == '.');
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QN) {
            QN that = (QN)obj;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

